const CACHE = 'sajil-modular-v1';
const ASSETS = [
  './','./index.html','./style.css','./core.js','./sw-register.js','./manifest.webmanifest',
  './icons/icon-192.png','./icons/icon-512.png',
  './features/autoTags.js','./features/naturalSearch.js','./features/sideAI.js','./features/quickEntry.js',
  './features/oneTap.js','./features/shareCard.js','./features/editHistory.js','./features/swipeActions.js',
  './features/reports.js','./features/goals.js','./features/settings.js','./features/assistant.js'
];
self.addEventListener('install', (e)=>{ e.waitUntil(caches.open(CACHE).then(c=>c.addAll(ASSETS))); self.skipWaiting(); });
self.addEventListener('activate', (e)=>{ e.waitUntil(self.clients.claim()); });
self.addEventListener('fetch', (e)=>{
  e.respondWith(caches.match(e.request).then(cached => cached || fetch(e.request).catch(()=>cached)));
});
