// storage.sync.js (Cloud + Local)
// يستخدم نفس Firebase App الموجود في /SAJiLAUTH/firebase.js (SAJIL_AUTH_FB)

(function(){
  const SAJiL = window.SAJIL = window.SAJIL || {};
  SAJiL.cloud = SAJiL.cloud || {};

  const LS_TX = 'sajil_tx_v3';
  const LS_SET = 'sajil_set_v3';

  let uid = null;
  let unsub = null;
  let pushing = false;
  let pendingPush = false;

  function lsGet(key, fallback){
    try { return JSON.parse(localStorage.getItem(key) || fallback); }
    catch { return JSON.parse(fallback); }
  }
  function lsSet(key, obj){
    localStorage.setItem(key, JSON.stringify(obj));
  }

  function getLocalTx(){ return lsGet(LS_TX,'[]'); }
  function setLocalTx(arr){ lsSet(LS_TX, arr); }

  function getLocalSettings(){ return Object.assign({}, lsGet(LS_SET,'{}')); }
  function setLocalSettings(s){ lsSet(LS_SET, s); }

  function userDoc(){
    return window.SAJIL_AUTH_FB.db
      .collection('users').doc(uid)
      .collection('meta').doc('blob');
  }

  async function pushNow(){
    if(!uid){
  pendingPush = true;
  return;
}
if(pushing) return;
    pushing = true;
    try{
      const tx = getLocalTx();
      const settings = getLocalSettings();
      const payload = { tx, settings, updatedAt: Date.now() };
      await userDoc().set(payload, { merge:true });

      // نخزن آخر وقت سحابة محليًا لمنع loops
      const s = getLocalSettings();
      s._lastRemoteAt = payload.updatedAt;
      setLocalSettings(s);
    }catch(e){
      console.log('Cloud push failed', e);
    }finally{
      pushing = false;
    }
  }

  let t=null;
  function schedulePush(){
    clearTimeout(t);
    t = setTimeout(pushNow, 600);
  }

  async function pullOnce(){
    try{
      const snap = await userDoc().get();
      if(!snap.exists) return;

      const data = snap.data() || {};
      const remoteAt = data.updatedAt || 0;
      const localAt = getLocalSettings()._lastRemoteAt || 0;

      // إذا السحابة أحدث -> طبّقها
      if(remoteAt > localAt){
        if(Array.isArray(data.tx)) setLocalTx(data.tx);
        if(data.settings && typeof data.settings === 'object'){
          const merged = Object.assign({}, getLocalSettings(), data.settings);
          merged._lastRemoteAt = remoteAt;
          setLocalSettings(merged);
        }else{
          const s = getLocalSettings();
          s._lastRemoteAt = remoteAt;
          setLocalSettings(s);
        }
        SAJiL.render && SAJiL.render();
      }
    }catch(e){}
  }

  function listenLive(){
    if(unsub){ unsub(); unsub=null; }
    unsub = userDoc().onSnapshot((snap)=>{
      if(!snap.exists) return;
      const data = snap.data() || {};
      const remoteAt = data.updatedAt || 0;
      const localAt = getLocalSettings()._lastRemoteAt || 0;

      // تجاهل رجوع نفس بياناتنا
      if(remoteAt <= localAt) return;

      if(Array.isArray(data.tx)) setLocalTx(data.tx);
      if(data.settings && typeof data.settings === 'object'){
        const merged = Object.assign({}, getLocalSettings(), data.settings);
        merged._lastRemoteAt = remoteAt;
        setLocalSettings(merged);
      }else{
        const s = getLocalSettings();
        s._lastRemoteAt = remoteAt;
        setLocalSettings(s);
      }

      SAJiL.render && SAJiL.render();
    }, (err)=>console.log('onSnapshot err', err));
  }

  // نعمل Override لدوال التخزين الحالية بدون حذف أي شيء
  const original = SAJiL.storage || {};
  SAJiL.storage = original;

  SAJiL.storage.getTx = function(){ return getLocalTx(); };
  SAJiL.storage.setTx = function(v){ setLocalTx(v); schedulePush(); };

SAJiL.storage.setTx = function(v){
  setLocalTx(v);
  pendingPush = true;
  pushNow();        // ✅ فوري
  schedulePush();   // ✅ احتياطي
};

SAJiL.storage.setSettings = function(s){
  setLocalSettings(s);
  pendingPush = true;
  pushNow();
  schedulePush();
};

  
SAJiL.cloud.init = function(){
  const auth = window.SAJIL_AUTH_FB?.auth;
  if(!auth){ console.log('Missing auth'); return Promise.resolve(); }

  // ✅ انتظر حتى يصبح المستخدم جاهز
  return new Promise((resolve)=>{
    const unsubAuth = auth.onAuthStateChanged(async (user)=>{
      if(!user){ 
        // غير مسجل - gate سيرجعك
        resolve();
        return;
      }

      // امنع تكرار init إذا اشتغل مرة
      if(uid === user.uid){
        resolve();
        return;
      }

      uid = user.uid;

      try{
		  if(pendingPush){
  pendingPush = false;
  await pushNow();
}
        await pullOnce();
        listenLive();
        schedulePush(); // يدفع المحلي مرة
      }catch(e){
        console.log('cloud init error', e);
      }finally{
        // نوقف listener الخاص بالـ auth بعد أول نجاح
        try{ unsubAuth(); }catch(e){}
        resolve();
      }
    });
  });
};


})();
