(function(){
  const SAJiL=window.SAJIL=window.SAJIL||{}; SAJiL.features=SAJiL.features||{};
  const F=SAJiL.features.sideAI={};
  const show=(txt, payload)=>{ SAJiL.state.ai=payload; SAJiL.ui.aiText().textContent=txt; SAJiL.ui.aiBox().classList.remove('hidden'); };
  const hide=()=>{ SAJiL.state.ai=null; SAJiL.ui.aiBox().classList.add('hidden'); };

  F.beforeCommit=function(tx){
    const s=SAJiL.state.settings;
    // U: suggest currency
    if(s.suggestCurrency && s.enableUSD && tx.currency==='₪' && s.lastCurrency==='$'){
      show('هل تريد استخدام الدولار ($) لهذه العملية؟', {kind:'currency', tx}); return true;
    }
    // 3: unusual
    const same=SAJiL.storage.getTx().filter(t=>t.note===tx.note && t.type===tx.type && t.currency===tx.currency);
    if(same.length>=4){
      const vals=same.map(t=>t.amount).sort((a,b)=>a-b).slice(-12);
      const med=vals[Math.floor(vals.length/2)];
      if(tx.amount>med*2.2 || tx.amount<med*0.35){
        show(`يبدو أن هذا المبلغ غير معتاد لـ “${tx.note}”. هل تريد المتابعة؟`, {kind:'unusual', tx}); return true;
      }
    }
    // tags suggestion
    if(s.autoTags && SAJiL.features.autoTags){
      const tags=SAJiL.features.autoTags.suggest(tx.note);
      if(tags.length){
        show(`اقتراح وسوم: ${tags.map(t=>'#'+t).join(' ')} — هل تريد إضافتها؟`, {kind:'tags', tx, tags}); return true;
      }
    }
    hide(); return false;
  };

  F.use=function(){
    const ai=SAJiL.state.ai; if(!ai) return;
    const s=SAJiL.state.settings;
    if(ai.kind==='currency'){ ai.tx.currency='$'; }
    if(ai.kind==='tags'){ ai.tx.tags=[...new Set([...(ai.tx.tags||[]), ...(ai.tags||[])])]; }
    s.lastCurrency = ai.tx.currency || '₪'; SAJiL.storage.setSettings(s);
    hide(); SAJiL.commit(ai.tx);
  };
  F.dismiss=function(){
    const ai=SAJiL.state.ai; if(!ai) return;
    hide(); SAJiL.commit(ai.tx);
  };
})();