(function(){
  const SAJiL=window.SAJIL=window.SAJIL||{}; SAJiL.features=SAJiL.features||{};
  const F=SAJiL.features.shareCard={};
  async function makeBlob(tx, privacy){
    const W=1080,H=600, c=document.createElement('canvas'); c.width=W; c.height=H;
    const ctx=c.getContext('2d'); const g=ctx.createLinearGradient(0,0,W,H);
    g.addColorStop(0,'#EEF5FF'); g.addColorStop(1,'#FFFFFF'); ctx.fillStyle=g; ctx.fillRect(0,0,W,H);
    const x=70,y=70,w=W-140,h=H-140,r=40;
    rr(x,y,w,h,r); ctx.fillStyle='rgba(255,255,255,0.92)'; ctx.fill(); ctx.strokeStyle='rgba(47,107,255,0.20)'; ctx.lineWidth=6; ctx.stroke();
    ctx.fillStyle='#0E1B3D'; ctx.font='900 54px Cairo, system-ui'; ctx.fillText('سَجل | SAJiL', x+60, y+95);
    const col=tx.type==='income'?'#19C37D':'#FF4D6D'; ctx.fillStyle=col; ctx.font='900 92px Cairo, system-ui';
    const amt=privacy?'•••'+(tx.currency||'₪'):`${tx.type==='income'?'+':'-'}${tx.amount}${tx.currency||'₪'}`;
    ctx.fillText(amt,x+60,y+215);
    ctx.fillStyle='#0E1B3D'; ctx.font='900 44px Cairo, system-ui'; ctx.fillText((tx.note||'—').slice(0,26),x+60,y+300);
    ctx.fillStyle='rgba(14,27,61,.65)'; ctx.font='900 34px Cairo, system-ui'; ctx.fillText(new Date(tx.date).toLocaleString('en-GB',{hour12:false}),x+60,y+360);
    return await new Promise(res=>c.toBlob(res,'image/png'));
    function rr(x,y,w,h,r){ ctx.beginPath(); ctx.moveTo(x+r,y); ctx.arcTo(x+w,y,x+w,y+h,r); ctx.arcTo(x+w,y+h,x,y+h,r); ctx.arcTo(x,y+h,x,y,r); ctx.arcTo(x,y,x+w,y,r); ctx.closePath(); }
  }
  F.share=async function(tx){
    const blob=await makeBlob(tx, SAJiL.state.settings.privacy);
    const file=new File([blob], `SAJiL-${tx.id}.png`, {type:'image/png'});
    if(navigator.share && navigator.canShare && navigator.canShare({files:[file]})){
      await navigator.share({files:[file], title:'SAJiL', text:'عملية من سَجل'});
    }else{
      const a=document.createElement('a'); a.href=URL.createObjectURL(blob); a.download=file.name; a.click();
      setTimeout(()=>URL.revokeObjectURL(a.href),2000);
    }
  };
})();