(function(){
  const SAJiL=window.SAJIL=window.SAJIL||{}; SAJiL.features=SAJiL.features||{};
  const F=SAJiL.features.reminder={};
  const LS='sajil_reminder_v1';
  function get(){ try{return JSON.parse(localStorage.getItem(LS)||'{}');}catch{return {}; } }
  function set(v){ localStorage.setItem(LS, JSON.stringify(v)); }
  function todayKey(){ return SAJiL.util?.dayKey ? SAJiL.util.dayKey() : new Date().toISOString().slice(0,10); }

  F.init=function(){
    try{
      const ui = SAJiL.ui;
      const key=todayKey();
      const st=get();
      if(st.dismissed===key) return;

      const all=SAJiL.storage.getTx();
      const hasToday = all.some(t=> (t.date||'').slice(0,10)===key);
      if(!hasToday){
        const el = ui.summaryMini && ui.summaryMini();
        if(el){
          const msg = '🔔 لم تسجل اليوم (من المساعد يمكن تجاهله)';
          if(!el.textContent.includes(msg)){
            el.textContent = (el.textContent? el.textContent+' — ' : '') + msg;
          }
        }
      }
    }catch(e){}
  };

  F.dismissToday=function(){
    const st=get();
    st.dismissed=todayKey();
    set(st);
    SAJiL.toast && SAJiL.toast('تم إخفاء التذكير لليوم');
    SAJiL.render && SAJiL.render();
  };
})();