(function(){
  const SAJiL=window.SAJIL=window.SAJIL||{}; SAJiL.features=SAJiL.features||{};
  const F=SAJiL.features.quickEntry={};

  function parse(text, s){
    const t=(text||'').trim(); if(!t) return null;

    let type=null;
    if(t.startsWith('+')) type='income';
    if(t.startsWith('-')) type='expense';

    // ✅ CHANGE: لا نفرض ₪ هنا. نخليها null إلا إذا المستخدم كتب $ أو ₪ صراحةً
    let currency=null;
    if(t.includes('$') && s.enableUSD) currency='$';
    if(t.includes('₪')) currency='₪';

    const m=t.match(/(\d+(?:\.\d+)?)/);
    const amount=m?parseFloat(m[1]):null;

    const note=t
      .replace(/[+\-]/g,'')
      .replace(/\$/g,'')
      .replace(/₪/g,'')
      .replace(/\d+(?:\.\d+)?/g,'')
      .trim();

    return {type,currency,amount,note};
  }

  F.saveFromUI=function(){
    const ui=SAJiL.ui, s=SAJiL.state.settings;
    const quick=ui.quickInput().value.trim();
    const note2=ui.noteInput().value.trim();
    const date=ui.dateInput().value ? new Date(ui.dateInput().value).toISOString() : new Date().toISOString();

    const p=parse(quick,s)||{type:null,currency:null,amount:null,note:''};

    const type = p.type || (s.guessType ? SAJiL.state.type : SAJiL.state.type);

    // ✅ CHANGE: العملة الافتراضية تأتي من زر العملة (SAJiL.state.currency)
    // إذا المستخدم كتب $ أو ₪ في النص، نأخذها
    let currency = p.currency || (SAJiL.state.currency || '₪');

    // ✅ إن كان الدولار غير مفعّل: امنع $
    if(currency==='$' && !s.enableUSD) currency='₪';

    const amount = p.amount || parseFloat(quick.replace(/[^\d.]/g,'')) || 0;
    if(!amount||amount<=0){ alert('أدخل مبلغ صحيح'); SAJiL.util.haptic([10,20,10]); return; }

    const tx={
      id:SAJiL.util.id(),
      type, amount, currency,
      note:(note2||p.note||'—').trim()||'—',
      tags:[],
      date,
      createdAt:Date.now(),
      updatedAt:Date.now()
    };

    if(SAJiL.features?.sideAI?.beforeCommit && SAJiL.features.sideAI.beforeCommit(tx)) return;

    SAJiL.commit(tx);
  };
})();
