(function(){
  const SAJiL=window.SAJIL=window.SAJIL||{}; SAJiL.features=SAJiL.features||{};
  const F=SAJiL.features.monthlyExport={};

  function monthRange(){
    const now=new Date();
    const from=new Date(now.getFullYear(), now.getMonth(), 1, 0,0,0,0);
    const to=new Date(now.getFullYear(), now.getMonth()+1, 0, 23,59,59,999);
    return {from, to};
  }

  function summarize(){
    const {from,to}=monthRange();
    const all=SAJiL.storage.getTx();
    let inc=0, exp=0;
    all.forEach(t=>{
      if(t.currency!=='₪') return;
      const ms=new Date(t.date).getTime();
      if(ms<from.getTime()||ms>to.getTime()) return;
      if(t.type==='income') inc+=t.amount; else exp+=t.amount;
    });
    return {inc, exp, net: inc-exp, from, to};
  }

  F.exportMonthImage=async function(){
    try{
      const sum=summarize();
      const W=1080,H=650;
      const c=document.createElement('canvas'); c.width=W; c.height=H;
      const ctx=c.getContext('2d');

      const g=ctx.createLinearGradient(0,0,W,H);
      g.addColorStop(0,'#EEF5FF'); g.addColorStop(1,'#FFFFFF');
      ctx.fillStyle=g; ctx.fillRect(0,0,W,H);

      const x=70,y=70,w=W-140,h=H-140,r=40;
      roundRect(x,y,w,h,r);
      ctx.fillStyle='rgba(255,255,255,0.92)'; ctx.fill();
      ctx.strokeStyle='rgba(47,107,255,0.20)'; ctx.lineWidth=6; ctx.stroke();

      ctx.fillStyle='#0E1B3D';
      ctx.font='900 54px Cairo, system-ui';
      ctx.fillText('SAJiL • ملخص شهري', x+60, y+95);

      ctx.font='900 38px Cairo, system-ui';
      const title = sum.from.toISOString().slice(0,7);
      ctx.fillStyle='rgba(14,27,61,.70)';
      ctx.fillText(title, x+60, y+145);

      ctx.fillStyle='#19C37D'; ctx.font='900 70px Cairo, system-ui';
      ctx.fillText('⬆︎ '+Math.round(sum.inc)+'₪', x+60, y+260);
      ctx.fillStyle='#FF4D6D';
      ctx.fillText('⬇︎ '+Math.round(sum.exp)+'₪', x+60, y+355);
      ctx.fillStyle='#2F6BFF';
      ctx.fillText('صافي '+Math.round(sum.net)+'₪', x+60, y+450);

      ctx.fillStyle='rgba(14,27,61,.70)'; ctx.font='900 30px Cairo, system-ui';
      ctx.fillText('تصدير بسيط — بدون تفاصيل', x+60, y+520);

      const blob = await new Promise(res=>c.toBlob(res,'image/png'));
      const file = new File([blob], `SAJiL-month-${title}.png`, {type:'image/png'});
      if(navigator.share && navigator.canShare && navigator.canShare({files:[file]})){
        await navigator.share({files:[file], title:'SAJiL', text:'ملخص شهري'});
      }else{
        const a=document.createElement('a'); a.href=URL.createObjectURL(blob); a.download=file.name; a.click();
        setTimeout(()=>URL.revokeObjectURL(a.href),2000);
      }

      function roundRect(x,y,w,h,r){
        ctx.beginPath();
        ctx.moveTo(x+r,y);
        ctx.arcTo(x+w,y,x+w,y+h,r);
        ctx.arcTo(x+w,y+h,x,y+h,r);
        ctx.arcTo(x,y+h,x,y,r);
        ctx.arcTo(x,y,x+w,y,r);
        ctx.closePath();
      }
    }catch(e){
      SAJiL.toast ? SAJiL.toast('تعذر إنشاء الصورة') : alert('تعذر إنشاء الصورة');
    }
  };
})();