(function(){
  const SAJiL = window.SAJIL = window.SAJIL || {};
  SAJiL.features = SAJiL.features || {};
  const F = SAJiL.features.longPress = {};

  let pressTimer=null, pressedId=null;

  function openMenu(tx){
    const sheet = document.getElementById('lpSheet');
    if(!sheet) return;
    sheet.classList.remove('hidden');
    SAJiL.ui?.modalBackdrop && SAJiL.ui.modalBackdrop().classList.remove('hidden');

    sheet.querySelector('#lpTitle').textContent = tx.note || '—';
    sheet.querySelector('#lpAmount').textContent = (tx.type==='income'?'+':'-') + SAJiL.util.fmtMoney(tx.amount, tx.currency, SAJiL.state.settings?.privacy);

    sheet.querySelector('#lpCopyAmount').onclick = async ()=>{ await navigator.clipboard.writeText(String(tx.amount)); SAJiL.toast&&SAJiL.toast('تم النسخ'); close(); };
    sheet.querySelector('#lpCopyNote').onclick = async ()=>{ await navigator.clipboard.writeText(String(tx.note||'')); SAJiL.toast&&SAJiL.toast('تم النسخ'); close(); };
    sheet.querySelector('#lpEdit').onclick = ()=>{ close(); SAJiL.features?.editHistory?.open && SAJiL.features.editHistory.open(tx.id); };
    sheet.querySelector('#lpShare').onclick = ()=>{ close(); SAJiL.features?.shareCard?.share && SAJiL.features.shareCard.share(tx); };
    sheet.querySelector('#lpDelete').onclick = ()=>{ 
      close();
      if(confirm('حذف العملية؟')){
        SAJiL.storage.setTx(SAJiL.storage.getTx().filter(t=>t.id!==tx.id));
        SAJiL.render();
        SAJiL.toast && SAJiL.toast('تم الحذف');
      }
    };

    function close(){
      sheet.classList.add('hidden');
      SAJiL.ui?.modalBackdrop && SAJiL.ui.modalBackdrop().classList.add('hidden');
    }
    sheet.querySelector('#lpClose').onclick = close;
  }

  function findTx(id){
    return SAJiL.storage.getTx().find(t=>t.id===id);
  }

  F.init = function(){
    // delegate long press on list
    const list = document.getElementById('list');
    if(!list) return;

    list.addEventListener('touchstart', (e)=>{
      const card = e.target.closest('.item__card');
      if(!card) return;
      const id = card.getAttribute('data-tx-id');
      if(!id) return;

      pressedId = id;
      pressTimer = setTimeout(()=>{
        const tx = findTx(pressedId);
        if(tx) openMenu(tx);
      }, 450);
    }, {passive:true});

    list.addEventListener('touchend', ()=>{ clearTimeout(pressTimer); pressTimer=null; }, {passive:true});
    list.addEventListener('touchmove', ()=>{ clearTimeout(pressTimer); pressTimer=null; }, {passive:true});
  };
})();
