(function(){
  const SAJiL=window.SAJIL=window.SAJIL||{}; SAJiL.features=SAJiL.features||{};
  const F=SAJiL.features.lock={};

  function show(){ document.getElementById('lockScreen')?.classList.remove('hidden'); }
  function hide(){ document.getElementById('lockScreen')?.classList.add('hidden'); }

  F.init=function(){
    try{
      const s = SAJiL.state.settings || SAJiL.storage.getSettings();
      if(!s.enableLock || !s.pin) return;

      show();
      const pinInp = document.getElementById('lockPin');
      const err = document.getElementById('lockErr');
      const btn = document.getElementById('unlockBtn');

      const attempt = ()=>{
        const v=(pinInp.value||'').replace(/\D/g,'');
        if(v === String(s.pin)){
          hide();
          pinInp.value='';
          err.classList.add('hidden');
          SAJiL.util?.haptic && SAJiL.util.haptic(10);
        }else{
          err.classList.remove('hidden');
          SAJiL.util?.haptic && SAJiL.util.haptic([10,20,10]);
        }
      };

      btn?.addEventListener('click', attempt);
      pinInp?.addEventListener('keydown', (e)=>{ if(e.key==='Enter') attempt(); });
    }catch(e){}
  };
})();