(function(){
  const SAJiL = window.SAJIL = window.SAJIL || {};
  SAJiL.features = SAJiL.features || {};
  const F = SAJiL.features.history = {};

  const LS = 'sajil_history_v1';
  const $ = (id)=>document.getElementById(id);

  function get(){ try{return JSON.parse(localStorage.getItem(LS)||'[]');}catch{return [];} }
  function set(v){ localStorage.setItem(LS, JSON.stringify(v)); }

  function push(entry){
    const arr = get();
    arr.unshift(entry);
    set(arr.slice(0,50));
  }

  F.log = function(type, tx, extra){
    try{
      push({
        at: Date.now(),
        type,
        id: tx?.id || null,
        amount: tx?.amount ?? null,
        currency: tx?.currency || '₪',
        note: tx?.note || '',
        meta: extra || null
      });
    }catch(e){}
  };

  function render(){
    const list = $('historyList');
    if(!list) return;
    const arr = get();
    list.innerHTML = '';
    if(!arr.length){
      list.innerHTML = '<div class="card muted">لا يوجد سجل بعد.</div>';
      return;
    }
    arr.forEach(h=>{
      const d = new Date(h.at);
      const time = d.toLocaleString('en-GB',{hour:'2-digit',minute:'2-digit'}) + ' • ' + d.toLocaleDateString('en-GB');
      const sign = (h.type==='add'||h.type==='dup') ? '➕' : (h.type==='edit'?'✏️': (h.type==='delete'?'🗑️':'ℹ️'));
      const amt = (h.amount!=null) ? `${h.amount}${h.currency||'₪'}` : '';
      const div = document.createElement('div');
      div.className = 'card';
      div.innerHTML = `<b>${sign} ${h.type}</b>
        <div class="muted">${time}</div>
        <div style="margin-top:6px">${SAJiL.util.esc(h.note||'—')}</div>
        <div class="muted" style="margin-top:6px">${amt}</div>`;
      list.appendChild(div);
    });
  }

  F.open = function(){
    SAJiL.ui.modalBackdrop().classList.remove('hidden');
    $('historySheet').classList.remove('hidden');
    render();
  };

  F.init = function(){
    $('btnHistory')?.addEventListener('click', F.open);
    $('closeHistory')?.addEventListener('click', ()=>{
      $('historySheet').classList.add('hidden');
      SAJiL.ui.modalBackdrop().classList.add('hidden');
    });
    $('historyClear')?.addEventListener('click', ()=>{
      if(!confirm('مسح السجل؟')) return;
      set([]);
      render();
      SAJiL.toast && SAJiL.toast('تم مسح السجل');
    });
  };
})();
