(function(){
  const SAJiL=window.SAJIL=window.SAJIL||{}; SAJiL.features=SAJiL.features||{};
  const F=SAJiL.features.dayMarkers={};
  const LS='sajil_day_markers_v1';

  function get(){ try{return JSON.parse(localStorage.getItem(LS)||'[]');}catch{return [];} }
  function set(v){ localStorage.setItem(LS, JSON.stringify(v)); }
  function todayKey(){ return SAJiL.util?.dayKey ? SAJiL.util.dayKey() : new Date().toISOString().slice(0,10); }

  F.mark=function(kind){
    const key=todayKey();
    const arr=get();
    if(arr.some(x=>x.key===key && x.kind===kind)){
      SAJiL.toast && SAJiL.toast('مسجل بالفعل اليوم');
      return;
    }
    arr.push({key, kind, at:Date.now()});
    set(arr);
    SAJiL.toast && SAJiL.toast(kind==='noExpense' ? 'تم تسجيل: يوم بلا مصروف' : 'تم تسجيل: يوم بلا مدخول (🗑️)');
    SAJiL.util?.haptic && SAJiL.util.haptic(8);
    SAJiL.render && SAJiL.render();
  };

  function renderToday(){
    const arr=get();
    const key=todayKey();
    const today = arr.filter(x=>x.key===key);
    const list = SAJiL.ui?.list && SAJiL.ui.list();
    if(!list) return;

    list.querySelectorAll('.markerCard').forEach(x=>x.remove());
    today.forEach(m=>{
      const div=document.createElement('div');
      div.className='card markerCard';
      const txt = m.kind==='noExpense' ? '✅ اليوم بلا مصروف' : '🗑️ اليوم بلا مدخول';
      div.innerHTML = `<b>${txt}</b><div class="muted">${key}</div>`;
      list.prepend(div);
    });
  }

  F.init=function(){
    const orig = SAJiL.render;
    if(typeof orig === 'function' && !orig._markersWrapped){
      const wrapped = function(){
        orig.apply(this, arguments);
        try{ renderToday(); }catch(e){}
      };
      wrapped._markersWrapped = true;
      SAJiL.render = wrapped;
    }
  };
})();