(function(){
  const SAJiL=window.SAJIL=window.SAJIL||{}; SAJiL.features=SAJiL.features||{};
  const F=SAJiL.features.compare={};

  function sumRange(from, to){
    const all=SAJiL.storage.getTx();
    let inc=0, exp=0;
    all.forEach(t=>{
      if(t.currency!=='₪') return;
      const ms=new Date(t.date).getTime();
      if(ms<from || ms>to) return;
      if(t.type==='income') inc+=t.amount; else exp+=t.amount;
    });
    return {inc:Math.round(inc), exp:Math.round(exp), net:Math.round(inc-exp)};
  }

  F.makeComparison=function(){
    const now=new Date();
    const end = new Date(now.getFullYear(), now.getMonth(), now.getDate(), 23,59,59,999).getTime();
    const startThis = end - 6*24*3600*1000;
    const endLast = startThis - 1;
    const startLast = endLast - 6*24*3600*1000;

    const thisWeek = sumRange(startThis, end);
    const lastWeek = sumRange(startLast, endLast);
    const delta = thisWeek.net - lastWeek.net;
    const deltaText = (delta>=0? '⬆︎ +' : '⬇︎ ') + Math.abs(delta) + '₪';

    return {thisWeek, lastWeek, deltaText};
  };
})();