(function(){
  const SAJiL = window.SAJIL = window.SAJIL || {};
  SAJiL.features = SAJiL.features || {};
  const F = SAJiL.features.bills = {};

  const LS = 'sajil_bills_v1';
  const $ = (id)=>document.getElementById(id);

  function getBills(){
    try{ return JSON.parse(localStorage.getItem(LS)||'[]'); }catch{ return []; }
  }
  function setBills(arr){
    localStorage.setItem(LS, JSON.stringify(arr));
  }

  function dowLabel(dateStr){
    if(!dateStr) return '';
    const d = new Date(dateStr+'T00:00:00');
    const map = ['الأحد','الإثنين','الثلاثاء','الأربعاء','الخميس','الجمعة','السبت'];
    return '• ' + map[d.getDay()];
  }

  function repeatHint(type){
    // weekly: times this month
    // monthly: times this year
    // yearly: no number
    const now = new Date();
    if(type==='weekly'){
      const daysInMonth = new Date(now.getFullYear(), now.getMonth()+1, 0).getDate();
      const times = Math.round(daysInMonth / 7);
      return `سيذكّرك تقريبًا ${times} مرات هذا الشهر`;
    }
    if(type==='monthly'){
      return `سيذكّرك 12 مرة بالسنة`;
    }
    return '';
  }

  function render(){
    const list = $('billsList');
    const count = $('billsCount');
    if(!list) return;
    const bills = getBills();
    if(count) count.textContent = `(${bills.length})`;
    list.innerHTML = '';

    bills.forEach(b=>{
      const div=document.createElement('div');
      div.className='billItem';
      div.innerHTML = `
        <div style="min-width:0">
          <b>${SAJiL.util.esc(b.name||'—')}</b>
          <div class="billMuted">
            ${b.amount}₪ • ${b.payLabel} • استحقاق ${b.dueDate} ${dowLabel(b.dueDate)}
            ${b.repeatOn ? ` • <span class="billTag">${b.repeatType}</span>` : ''}
            ${b.enabled ? '' : ' • (موقوف)'}
          </div>
        </div>
        <div class="billBtns">
          <button class="iconBtn" title="سجلها اليوم">➕</button>
          <button class="iconBtn" title="تبديل تفعيل">⏻</button>
          <button class="iconBtn" title="حذف">🗑️</button>
        </div>
      `;

      const [btnAdd, btnToggle, btnDel] = div.querySelectorAll('.iconBtn');

      btnAdd.addEventListener('click', ()=> addAsTxToday(b));
      btnToggle.addEventListener('click', ()=>{
        b.enabled = !b.enabled;
        setBills(bills);
        render();
        SAJiL.toast && SAJiL.toast(b.enabled ? 'تم التفعيل' : 'تم الإيقاف');
      });
      btnDel.addEventListener('click', ()=>{
        if(!confirm('حذف الفاتورة؟')) return;
        const next = bills.filter(x=>x.id!==b.id);
        setBills(next);
        render();
        SAJiL.toast && SAJiL.toast('تم الحذف');
      });

      list.appendChild(div);
    });
  }

  function addAsTxToday(bill){
    if(!bill.enabled){
      SAJiL.toast && SAJiL.toast('الفاتورة موقوفة');
      return;
    }
    const tx = {
      id: SAJiL.util.id(),
      type: 'expense',
      amount: +bill.amount || 0,
      currency: '₪',
      note: `[BILL] ${bill.name} • ${bill.payLabel} • استحقاق ${bill.dueDate}`,
      date: new Date().toISOString(),
      tags: ['فاتورة'],
      createdAt: Date.now(),
      updatedAt: Date.now()
    };
    SAJiL.commit(tx);

    // Make bill label visually special (optional): renderList can add class if note contains [BILL]
    SAJiL.toast && SAJiL.toast('تم تسجيل الفاتورة كعملية اليوم ✅');
  }

  function saveBill(){
    const name = ($('billName').value||'').trim();
    const pay = $('billPay').value;
    const payLabel = $('billPay').selectedOptions?.[0]?.textContent || pay;
    const amount = ($('billAmount').value||'').trim();
    const dueDate = $('billDueDate').value;
    const invoiceDate = $('billInvoiceDate').value;
    const repeatOn = $('billRepeatOn').checked;
    const repeatType = $('billRepeatType').value;
    const enabled = $('billEnabled').checked;

    if(!name){ SAJiL.toast && SAJiL.toast('اكتب اسم الفاتورة'); return; }
    if(!amount || isNaN(+amount)){ SAJiL.toast && SAJiL.toast('اكتب مبلغ صحيح'); return; }
    if(!dueDate){ SAJiL.toast && SAJiL.toast('اختر تاريخ الاستحقاق'); return; }
    if(!invoiceDate){ SAJiL.toast && SAJiL.toast('اختر تاريخ الفاتورة'); return; }

    const bill = {
      id: SAJiL.util.id(),
      name, pay, payLabel,
      amount: Math.round((+amount)*100)/100,
      dueDate, invoiceDate,
      repeatOn, repeatType,
      enabled,
      createdAt: Date.now()
    };

    const bills = getBills();
    bills.unshift(bill);
    setBills(bills);

    $('billName').value='';
    $('billAmount').value='';
    $('billDueDate').value='';
    $('billInvoiceDate').value='';
    $('billRepeatOn').checked=false;
    $('billRepeatRow').classList.add('hidden');
    $('billRepeatHint').textContent='';
    $('billEnabled').checked=true;

    render();
    SAJiL.toast && SAJiL.toast('تم حفظ الفاتورة ✅');
  }

  F.init = function(){
    // open/close via assistant
    $('asBills')?.addEventListener('click', ()=>{
      SAJiL.ui.modalBackdrop().classList.remove('hidden');
      $('billsSheet').classList.remove('hidden');
      render();
    });
    $('closeBills')?.addEventListener('click', ()=>{
      $('billsSheet').classList.add('hidden');
      SAJiL.ui.modalBackdrop().classList.add('hidden');
    });

    // due day label
    $('billDueDate')?.addEventListener('change', ()=>{
      $('billDueDow').textContent = dowLabel($('billDueDate').value);
    });

    // repeat toggle
    $('billRepeatOn')?.addEventListener('change', ()=>{
      const on = $('billRepeatOn').checked;
      $('billRepeatRow').classList.toggle('hidden', !on);
      if(on){
        $('billRepeatHint').textContent = repeatHint($('billRepeatType').value);
      }else{
        $('billRepeatHint').textContent = '';
      }
    });
    $('billRepeatType')?.addEventListener('change', ()=>{
      if($('billRepeatOn').checked){
        $('billRepeatHint').textContent = repeatHint($('billRepeatType').value);
      }
    });

    // buttons
    $('billSave')?.addEventListener('click', saveBill);
    $('billAddToday')?.addEventListener('click', ()=>{
      // Create temp bill from current form then add
      const name = ($('billName').value||'').trim();
      const payLabel = $('billPay').selectedOptions?.[0]?.textContent || $('billPay').value;
      const amount = ($('billAmount').value||'').trim();
      const dueDate = $('billDueDate').value;
      if(!name || !amount || isNaN(+amount) || !dueDate){
        SAJiL.toast && SAJiL.toast('املأ الاسم + المبلغ + تاريخ الاستحقاق');
        return;
      }
      addAsTxToday({
        enabled:true,
        name,
        payLabel,
        amount:+amount,
        dueDate
      });
    });

    render();
  };

})();
