(function(){
  const SAJiL=window.SAJIL=window.SAJIL||{}; SAJiL.features=SAJiL.features||{};
  const F=SAJiL.features.assistant={};
  const $=(id)=>document.getElementById(id);
  F.init=function(){
    const toast = (m)=> (SAJiL.toast ? SAJiL.toast(m) : alert(m));

    $('asTips').addEventListener('click', ()=>{
      $('assistantOut').innerHTML = `<b>نصائح</b>
        <div class="muted">• اكتب +1500 أو -200 مع الملاحظة لتسجيل أسرع.</div>
        <div class="muted">• ابحث: “أمس تلفونات” أو “فوق 500”.</div>
        <div class="muted">• اسحب العملية لخيارات حذف/تكرار/مشاركة.</div>`;
    });
    $('asReport').addEventListener('click', ()=>{
      const all=SAJiL.storage.getTx(); const weekAgo=Date.now()-7*24*3600*1000;
      const items=all.filter(t=>new Date(t.date).getTime()>=weekAgo && t.currency==='₪');
      let inc=0,exp=0; items.forEach(t=>{ if(t.type==='income') inc+=t.amount; else exp+=t.amount; });
      $('assistantOut').innerHTML = `<b>ملخص الأسبوع</b>
        <div class="muted">⬆︎ مدخول: ${SAJiL.util.fmtMoney(inc,'₪',false)}</div>
        <div class="muted">⬇︎ مصروف: ${SAJiL.util.fmtMoney(exp,'₪',false)}</div>
        <div class="muted">الصافي: ${SAJiL.util.fmtMoney(inc-exp,'₪',false)}</div>`;
    });

    // Compare (on demand)
    const cmpBtn = document.getElementById('asCompare');
    if(cmpBtn){
      cmpBtn.addEventListener('click', ()=>{
        const res = SAJiL.features?.compare?.makeComparison ? SAJiL.features.compare.makeComparison() : null;
        if(!res){ toast('ميزة المقارنة غير جاهزة'); return; }
        document.getElementById('assistantOut').innerHTML =
          `<b>مقارنة</b>
           <div class="muted">هذا الأسبوع: ⬆︎ ${res.thisWeek.inc}₪ • ⬇︎ ${res.thisWeek.exp}₪ • صافي ${res.thisWeek.net}₪</div>
           <div class="muted">الأسبوع الماضي: ⬆︎ ${res.lastWeek.inc}₪ • ⬇︎ ${res.lastWeek.exp}₪ • صافي ${res.lastWeek.net}₪</div>
           <div class="muted">الفرق: ${res.deltaText}</div>`;
      });
    }

    // Monthly image
    const monBtn = document.getElementById('asMonthlyImg');
    if(monBtn){
      monBtn.addEventListener('click', ()=>{
        SAJiL.features?.monthlyExport?.exportMonthImage && SAJiL.features.monthlyExport.exportMonthImage();
      });
    }

const aiBtn = document.getElementById('asAI');
if(aiBtn){
  aiBtn.addEventListener('click', ()=>{
    const out = document.getElementById('assistantOut');
    if(SAJiL.features?.aiInsights?.build){
      out.innerHTML = SAJiL.features.aiInsights.build();
    }else{
      SAJiL.toast && SAJiL.toast('AI غير جاهز');
    }
  });
}


  };
})();
