(function(){
  const SAJiL = window.SAJIL = window.SAJIL || {};
  SAJiL.features = SAJiL.features || {};
  const F = SAJiL.features.aiInsights = {};

  function sumRange(fromMs, toMs){
    const all = SAJiL.storage.getTx();
    let inc=0, exp=0;
    all.forEach(t=>{
      if(t.currency!=='₪') return;
      const ms = new Date(t.date).getTime();
      if(ms<fromMs || ms>toMs) return;
      if(t.type==='income') inc += t.amount;
      else exp += t.amount;
    });
    return {inc:Math.round(inc), exp:Math.round(exp), net:Math.round(inc-exp)};
  }

  function topNotes(days=30){
    const all = SAJiL.storage.getTx();
    const from = Date.now() - days*24*3600*1000;
    const m = {};
    all.forEach(t=>{
      const ms = new Date(t.date).getTime();
      if(ms < from) return;
      const key = (t.note||'—').trim();
      m[key] = (m[key]||0) + (t.type==='expense' ? t.amount : 0);
    });
    return Object.entries(m).sort((a,b)=>b[1]-a[1]).slice(0,3);
  }

  F.build = function(){
    const now = new Date();
    const end = new Date(now.getFullYear(), now.getMonth(), now.getDate(), 23,59,59,999).getTime();
    const startThis = end - 6*24*3600*1000;
    const endLast = startThis - 1;
    const startLast = endLast - 6*24*3600*1000;

    const thisWeek = sumRange(startThis, end);
    const lastWeek = sumRange(startLast, endLast);
    const delta = thisWeek.net - lastWeek.net;

    const tops = topNotes(30);
    const topHtml = tops.length
      ? tops.map(([k,v])=>`<div class="muted">• ${SAJiL.util.esc(k)}: ${Math.round(v)}₪</div>`).join('')
      : `<div class="muted">• لا يوجد بيانات كافية</div>`;

    return `
      <b>AI • Insights</b>
      <div class="muted">هذا الأسبوع: ⬆︎ ${thisWeek.inc}₪ • ⬇︎ ${thisWeek.exp}₪ • صافي ${thisWeek.net}₪</div>
      <div class="muted">الأسبوع الماضي: ⬆︎ ${lastWeek.inc}₪ • ⬇︎ ${lastWeek.exp}₪ • صافي ${lastWeek.net}₪</div>
      <div class="muted">الفرق: ${(delta>=0?'⬆︎ +':'⬇︎ ') + Math.abs(delta)}₪</div>
      <div style="height:10px"></div>
      <b>أعلى مصاريف (30 يوم)</b>
      ${topHtml}
    `;
  };
})();
