(function(){
  const SAJiL=window.SAJIL=window.SAJIL||{}; SAJiL.features=SAJiL.features||{};
  const F=SAJiL.features.swipeActions={};
  F.renderList=function(items){
    const ui=SAJiL.ui, s=SAJiL.state.settings; ui.list().innerHTML='';
    if(!items.length){ ui.list().innerHTML='<div class="card muted">لا توجد عمليات.</div>'; return; }
    items.forEach(tx=>{
      const wrap=document.createElement('div'); wrap.className='item '+tx.type;
      const actions=document.createElement('div'); actions.className='item__actions';
      actions.innerHTML=`<button class="actionBtn" data-act="delete">🗑️ حذف</button>
        <button class="actionBtn" data-act="dup">↩️ تكرار</button>
        <button class="actionBtn" data-act="share">📤 مشاركة</button>`;
      const card=document.createElement('div'); card.className='item__card';
      const tags=(tx.tags||[]).map(t=>'#'+t).join(' ');
      card.innerHTML=`<div class="badgeType">${tx.type==='income'?'⬆︎':'⬇︎'}</div>
        <div class="meta"><div class="note">${SAJiL.util.esc(tx.note)}</div><div class="date">${SAJiL.util.fmtDate(tx.date)}</div>${tags?`<div class="tags">${SAJiL.util.esc(tags)}</div>`:''}</div>
        <div class="amount">${tx.type==='income'?'+':'-'}${SAJiL.util.fmtMoney(tx.amount,tx.currency,s.privacy)}</div>
        <div class="swipeHint"><span class="grip">⋮⋮</span><span>››</span></div>`;
      wrap.appendChild(actions); wrap.appendChild(card); ui.list().appendChild(wrap);
      wireSwipe(card);
      actions.addEventListener('click',(e)=>{
        const b=e.target.closest('[data-act]'); if(!b) return;
        const act=b.dataset.act;
        if(act==='delete'){ if(confirm('حذف العملية؟')){ SAJiL.storage.setTx(SAJiL.storage.getTx().filter(t=>t.id!==tx.id)); SAJiL.util.haptic(10); SAJiL.render(); } }
        if(act==='dup'){ const copy=Object.assign({},tx,{id:SAJiL.util.id(),date:new Date().toISOString(),createdAt:Date.now(),updatedAt:Date.now()}); SAJiL.commit(copy); }
        if(act==='share'){ SAJiL.features?.shareCard?.share && SAJiL.features.shareCard.share(tx); }
        card.style.transform='translateX(0px)';
      });
      function wireSwipe(el){
        let sx=0,cx=0,drag=false; const max=120;
        const down=(ev)=>{drag=true; sx=(ev.touches?ev.touches[0].clientX:ev.clientX); el.style.transition='none';};
        const move=(ev)=>{ if(!drag) return; const x=(ev.touches?ev.touches[0].clientX:ev.clientX); cx=x-sx; cx=Math.max(-max,Math.min(max,cx)); el.style.transform=`translateX(${cx}px)`; };
        const up=()=>{ if(!drag) return; drag=false; el.style.transition='transform .18s ease'; el.style.transform=(Math.abs(cx)>60)?`translateX(${cx>0?max:-max}px)`:'translateX(0px)'; SAJiL.util.haptic(5); };
        el.addEventListener('mousedown',down); el.addEventListener('mousemove',move); window.addEventListener('mouseup',up);
        el.addEventListener('touchstart',down,{passive:true}); el.addEventListener('touchmove',move,{passive:true}); el.addEventListener('touchend',up);
      }
    });
  };
})();