(function(){
  const SAJiL=window.SAJIL=window.SAJIL||{}; SAJiL.features=SAJiL.features||{};
  const F=SAJiL.features.settings={};
  const $=(id)=>document.getElementById(id);
  function apply(){
    const s=SAJiL.state.settings;
    $('setEnableUSD').checked=!!s.enableUSD;
    $('setGuessType').checked=!!s.guessType;
    $('setPrivacy').checked=!!s.privacy;
    $('setAutoTags').checked=!!s.autoTags;
    $('setSuggestCurrency').checked=!!s.suggestCurrency;
    $('setSuggestReports').checked=!!s.suggestReports;
    $('setRequireReason').checked=!!s.requireReason;
    $('setGoalsOn').checked=!!s.goalsOn;
    $('goalCard').classList.toggle('show', !!s.goalsOn);
    $('goalExpense').value=s.goalExpense?String(s.goalExpense):'';
    $('goalNet').value=s.goalNet?String(s.goalNet):'';
  }
  function patch(p){ Object.assign(SAJiL.state.settings,p); SAJiL.storage.setSettings(SAJiL.state.settings); apply(); SAJiL.render(); }
  F.init=function(){
    apply();
    $('setEnableUSD').addEventListener('change',()=>patch({enableUSD:$('setEnableUSD').checked}));
    $('setGuessType').addEventListener('change',()=>patch({guessType:$('setGuessType').checked}));
    $('setPrivacy').addEventListener('change',()=>patch({privacy:$('setPrivacy').checked}));
    $('setAutoTags').addEventListener('change',()=>patch({autoTags:$('setAutoTags').checked}));
    $('setSuggestCurrency').addEventListener('change',()=>patch({suggestCurrency:$('setSuggestCurrency').checked}));
    $('setSuggestReports').addEventListener('change',()=>patch({suggestReports:$('setSuggestReports').checked}));
    $('setRequireReason').addEventListener('change',()=>patch({requireReason:$('setRequireReason').checked}));
    $('setGoalsOn').addEventListener('change',()=>patch({goalsOn:$('setGoalsOn').checked}));
    $('saveGoals').addEventListener('click',()=>{
      const ge=parseFloat(($('goalExpense').value||'').replace(/[^\d.]/g,''))||0;
      const gn=parseFloat(($('goalNet').value||'').replace(/[^\d.]/g,''))||0;
      patch({goalExpense:ge,goalNet:gn}); SAJiL.util.haptic(10);
    });
    $('btnReset').addEventListener('click',()=>{
      if(!confirm('سيتم مسح كل البيانات. هل أنت متأكد؟')) return;
      localStorage.clear();
      SAJiL.state.settings = SAJiL.storage.getSettings();
      apply(); SAJiL.render();
    });
  };
})();