(function(){
  const SAJiL=window.SAJIL=window.SAJIL||{}; SAJiL.features=SAJiL.features||{};
  const F=SAJiL.features.reports={};
  function weekItems(){
    const all=SAJiL.storage.getTx(); const weekAgo=Date.now()-7*24*3600*1000;
    return all.filter(t=>new Date(t.date).getTime()>=weekAgo);
  }
  F.afterSave=function(){
    const s=SAJiL.state.settings;
    if(!s.suggestReports) return;
    const today=new Date().toISOString().slice(0,10);
    if(s.lastReportPrompt===today) return;
    if(weekItems().length>=8){
      SAJiL.ui.aiText().textContent='هل تحب تشوف ملخص الأسبوع؟';
      SAJiL.state.ai={kind:'report'};
      SAJiL.ui.aiBox().classList.remove('hidden');
      s.lastReportPrompt=today; SAJiL.storage.setSettings(s);
    }
  };
  F.csvExport=function(items){
    const rows=[['id','type','amount','currency','note','tags','date']];
    items.forEach(t=>rows.push([t.id,t.type,t.amount,t.currency,(t.note||'').replace(/\n/g,' '),(t.tags||[]).join('|'),t.date]));
    return rows.map(r=>r.map(v=>{const s=String(v); return s.includes(',')?`"${s.replace(/"/g,'""')}"`:s;}).join(',')).join('\n');
  };
})();