/* ===== firebase.js — iDEO Firebase Bridge (Anonymous Auth + Firestore) =====
   يعمل كـ <script> عادي. يوفّر window.FirebaseAPI:
   - ready: Promise
   - getUID(): string
   - upsert(kind, item)
   - remove(kind, id)
   - watch(kind, cb)
   - migrateIfEmpty({tasks, notes, archived})
   المجموعات: users/{uid}/tasks | notes | archived
*/

(function(){
  const cfg = {
    apiKey: "AIzaSyArzQKGWP9aRejouVgpCHC7_TMLqrTt4U4",
    authDomain: "ideo-idea.firebaseapp.com",
    projectId: "ideo-idea",
    storageBucket: "ideo-idea.firebasestorage.app",
    messagingSenderId: "60247618579",
    appId: "1:60247618579:web:e585f08af36a684ef5bbe6",
    measurementId: "G-YTSNP40GXP"
  };

  const FIREBASE_V = "10.14.1";
  const urls = {
    app: `https://www.gstatic.com/firebasejs/${FIREBASE_V}/firebase-app.js`,
    auth: `https://www.gstatic.com/firebasejs/${FIREBASE_V}/firebase-auth.js`,
    fs: `https://www.gstatic.com/firebasejs/${FIREBASE_V}/firebase-firestore.js`
  };

  let app, auth, db, uid=null;
  let modApp, modAuth, modFs;

  const ready = (async()=>{
    // تحميل SDK Modular ديناميكيًا
    [modApp, modAuth, modFs] = await Promise.all([
      import(urls.app),
      import(urls.auth),
      import(urls.fs)
    ]);
    app  = modApp.initializeApp(cfg);
    auth = (0, modAuth.getAuth)(app);

    // تفعيل Firestore + Persistence
    db = (0, modFs.getFirestore)(app);
    try { await modFs.enableIndexedDbPersistence(db); } catch(e){ /* قد تفشل لو تعدد تبويبات */ }

    // Anonymous Auth
    try { await (0, modAuth.signInAnonymously)(auth); } catch(e){ /* قد يكون مسجل مسبقًا */ }
    await new Promise(res => (0, modAuth.onAuthStateChanged)(auth, u => { if(u){ uid = u.uid; res(); }}));
    return true;
  })();

  function colRef(kind){ return (0, modFs.collection)(db, "users", uid, kind); }
  function docRef(kind, id){ return (0, modFs.doc)(db, "users", uid, kind, id); }

  async function upsert(kind, item){
    if(!uid) await ready;
    const payload = {...item, updatedAt: Date.now()};
    await (0, modFs.setDoc)(docRef(kind, payload.id), payload, { merge:true });
  }

  async function remove(kind, id){
    if(!uid) await ready;
    await (0, modFs.deleteDoc)(docRef(kind, id));
  }

  function watch(kind, cb){
    const q = (0, modFs.query)(colRef(kind), (0, modFs.orderBy)("updatedAt","desc"));
    return (0, modFs.onSnapshot)(q, snap=>{
      const list = snap.docs.map(d=>d.data());
      cb(list);
    });
  }

  async function migrateIfEmpty(initial){
    if(!uid) await ready;
    // تحقّق إن كانت المجموعات فارغة
    const counts = {};
    for (const k of ["tasks","notes","archived"]) {
      const snap = await (0, modFs.getDocs)(colRef(k));
      counts[k] = snap.size;
    }
    if(counts.tasks===0 && counts.notes===0 && counts.archived===0){
      // ارفع محليًا لأول مرة
      const now = Date.now();
      const putAll = [];
      (initial.tasks||[]).forEach(it=> putAll.push(upsert("tasks", {...it, updatedAt: it.updatedAt || now})));
      (initial.notes||[]).forEach(it=> putAll.push(upsert("notes", {...it, updatedAt: it.updatedAt || now})));
      (initial.archived||[]).forEach((it,idx)=>{
        const id = it.id || (it.item?.id ? (it.item.id+"_"+(now+idx)) : String(now+idx));
        putAll.push(upsert("archived", {...it, id, updatedAt: it.updatedAt || now}));
      });
      await Promise.allSettled(putAll);
    }
  }

  window.FirebaseAPI = {
    ready,
    getUID: ()=>uid,
    upsert,
    remove,
    watch,
    migrateIfEmpty
  };
})();
