/* ===== iDEO Main JS — Unified (2025-10-14 + requested fixes 2025-10-18) ===== */

const STORE = {TASKS:"ideo_tasks_v3",NOTES:"ideo_notes_v3",ARCH:"ideo_archived_v3",PREFS:"ideo_prefs_v1"};
function loadPrefs(){ try{return JSON.parse(localStorage.getItem(STORE.PREFS)||"{}");}catch{return{}} }
function savePrefs(p){ localStorage.setItem(STORE.PREFS, JSON.stringify(p)); }
const prefs = loadPrefs();
const state = {darkMode:!!prefs.darkMode,showHolidays:prefs.showHolidays!==false,tasks:JSON.parse(localStorage.getItem(STORE.TASKS)||"[]"),notes:JSON.parse(localStorage.getItem(STORE.NOTES)||"[]"),archived:JSON.parse(localStorage.getItem(STORE.ARCH)||"[]"),selectedDate:null,snapshot:null,view:{m:(new Date()).getMonth(),y:(new Date()).getFullYear()},currentTaskId:null,currentNoteId:null,holidaysData:null,filters:{status:"",prio:""}};
const byId=(id)=>document.getElementById(id);
const toastWrap=byId("toastWrap"),monthEl=byId("monthNumber"),yearEl=byId("yearNum"),grid=byId("calendarGrid"),searchEl=byId("search"),showAllBtn=byId("showAll");
const settingsBtn=byId("settingsBtn"),settingsPop=byId("settingsPop"),skinToggle=byId("skinToggle"),toggleHolidays=byId("toggleHolidays"),refreshHolidays=byId("refreshHolidays");
const notesAuto=byId("notesAuto"),notesSearch=byId("notesSearch");
const sheet=byId("sheet"),fab=byId("fab"),sheetClose=byId("sheetClose"),sheetReset=byId("sheetReset"),sheetSave=byId("sheetSave");
const titleEl=byId("title"),statusEl=byId("status"),typeEl=byId("type"),prioEl=byId("priority"),createdEl=byId("createdAt"),dueEl=byId("due"),notesEl=byId("notes"),editIdEl=byId("editId"),smartHint=byId("smartHint");
const filterStatus=byId("filterStatus"),filterPrio=byId("filterPrio");
const lists={todo:byId("list-todo"),doing:byId("list-doing"),think:byId("list-think"),done:byId("list-done")};
const counts={todo:byId("count-todo"),doing:byId("count-doing"),think:byId("count-think"),done:byId("count-done")};

function toLocalYMD(d){const y=d.getFullYear(),m=d.getMonth()+1,day=d.getDate();return `${y}-${String(m).padStart(2,'0')}-${String(day).padStart(2,'0')}`;}
function parseYMD(s){const [y,m,d]=s.split('-').map(Number);return new Date(y,m-1,d);}
function todayYMD(){return toLocalYMD(new Date());}
function uid(){return Math.random().toString(36).slice(2,10);}
function clamp(n,min,max){return Math.min(max,Math.max(min,n));}
function escapeHTML(s){return (s||"").replace(/[&<>\"']/g,m=>({"&":"&amp;","<":"&lt;",">":"&gt;","\"":"&quot;","'":"&#39;"}[m]));}
function debounce(fn,ms){let t=null;return(...a)=>{clearTimeout(t);t=setTimeout(()=>fn(...a),ms);};}

function saveAll(){localStorage.setItem(STORE.TASKS,JSON.stringify(state.tasks));localStorage.setItem(STORE.NOTES,JSON.stringify(state.notes));localStorage.setItem(STORE.ARCH,JSON.stringify(state.archived));savePrefs({darkMode:state.darkMode,showHolidays:state.showHolidays});}
function snapshot(){state.snapshot=JSON.stringify({tasks:state.tasks,notes:state.notes,archived:state.archived,prefs:{darkMode:state.darkMode,showHolidays:state.showHolidays}});}
function undo(){if(!state.snapshot)return;try{const prev=JSON.parse(state.snapshot);state.tasks=prev.tasks;state.notes=prev.notes;state.archived=prev.archived;state.darkMode=!!prev.prefs.darkMode;state.showHolidays=prev.prefs.showHolidays!==false;state.snapshot=null;applyDarkMode();saveAll();renderCalendar();renderTasks();renderNotes();showToast("success","↩️ تم التراجع عن آخر إجراء");}catch{}}
function showToast(kind,text,withUndo=false){const t=document.createElement("div");t.className=`toast ${kind}`;const msg=document.createElement("span");msg.textContent=text;t.appendChild(msg);if(withUndo){const u=document.createElement("button");u.className="undo";u.textContent="↩️ تراجع";u.addEventListener("click",()=>{t.remove();undo();});t.appendChild(u);}const x=document.createElement("button");x.className="close";x.textContent="✕";x.addEventListener("click",()=>t.remove());t.appendChild(x);toastWrap.appendChild(t);setTimeout(()=>t.remove(),5000);}

function applyDarkMode(){document.body.classList.toggle("dark",state.darkMode);skinToggle.checked=state.darkMode;}
settingsPop.hidden=true;
settingsBtn.addEventListener("click",e=>{e.stopPropagation();settingsPop.hidden=!settingsPop.hidden;});
document.addEventListener("click",e=>{if(!settingsPop.hidden && !settingsPop.contains(e.target) && !settingsBtn.contains(e.target)) settingsPop.hidden=true;});
skinToggle.addEventListener("change",e=>{snapshot();state.darkMode=e.target.checked;applyDarkMode();saveAll();showToast("info",state.darkMode?"🌙 الوضع الليلي مفعل":"☀️ الوضع النهاري مفعل",true);});
toggleHolidays.checked=state.showHolidays;
toggleHolidays.addEventListener("change",e=>{snapshot();state.showHolidays=e.target.checked;saveAll();renderCalendar();showToast("info",state.showHolidays?"📅 ستظهر المناسبات":"📅 تم إخفاء المناسبات",true);});
refreshHolidays.addEventListener("click",()=>{renderCalendar();showToast("success","🔄 تم تحديث التقويم");});

/* ===== Firebase Sync Layer (Non-breaking) ===== */
const cloud = {
  async upsert(kind, item){ try{ if(window.FirebaseAPI){ await FirebaseAPI.ready; await FirebaseAPI.upsert(kind,item);} }catch{} },
  async remove(kind, id){   try{ if(window.FirebaseAPI){ await FirebaseAPI.ready; await FirebaseAPI.remove(kind,id);} }catch{} },
  async migrateIfEmpty(initial){ try{ if(window.FirebaseAPI){ await FirebaseAPI.ready; await FirebaseAPI.migrateIfEmpty(initial);} }catch{} },
  watch(kind, cb){ try{ if(window.FirebaseAPI){ return FirebaseAPI.watch(kind,cb);} }catch{} return ()=>{}; }
};
function cloudUpsert(kind,item){ return cloud.upsert(kind,item); }
function cloudRemove(kind,id){   return cloud.remove(kind,id); }
async function bootFirebaseSync(){
  if(!window.FirebaseAPI) return;
  await FirebaseAPI.ready;
  await cloud.migrateIfEmpty({ tasks: state.tasks, notes: state.notes, archived: state.archived });
  cloud.watch("tasks", list=>{ state.tasks = Array.isArray(list)?list:[]; saveAll(); renderTasks(); renderCalendar(); });
  cloud.watch("notes", list=>{ state.notes = Array.isArray(list)?list:[]; saveAll(); renderNotes(); });
  cloud.watch("archived", list=>{ state.archived = Array.isArray(list)?list:[]; saveAll(); });
}

async function ensureHolidaysLoaded(){if(state.holidaysData) return;const paths=["data/holidays.json","holidays.json"];for(const p of paths){try{const res=await fetch(p,{cache:"no-store"});if(res.ok){state.holidaysData=await res.json();return;}}catch{}}state.holidaysData={};showToast("info","لم يتم العثور على ملف الأعياد (holidays.json). ضع الملف داخل /data/ أو بجانب index.html.");}
function getHolidaysForYear(year){const y=String(year);return (state.holidaysData && state.holidaysData[y])?state.holidaysData[y]:{};}
const hebWeekdays=["ראשון","שני","שלישי","רביעי","חמישי","שישי","שבת"];
function daysLeftLabel(dueStr){if(!dueStr) return "";const today=parseYMD(todayYMD());const due=parseYMD(dueStr);const diff=Math.floor((due-today)/(1000*60*60*24));if(diff>0) return `تبقّى ${diff} يوم`; if(diff===0) return `اليوم`; return `متأخرة ${abs(diff)} يوم`;}
function abs(n){return n<0?-n:n;}

/* أولوية بالعربية للجوال وكل الواجهات */
function priorityLabel(pr){
  const m={low:"منخفضة",med:"متوسطة",high:"مرتفعة"};
  return m[pr]||pr||"متوسطة";
}

async function renderCalendar(){
  await ensureHolidaysLoaded();
  grid.innerHTML="";
  hebWeekdays.forEach(w=>{const el=document.createElement("div");el.className="weekday";el.textContent=w;grid.appendChild(el);});
  const first=new Date(state.view.y,state.view.m,1);
  const start=first.getDay();
  const days=new Date(state.view.y,state.view.m+1,0).getDate();
  monthEl.textContent=String(state.view.m+1).padStart(2,'0');
  yearEl.textContent=state.view.y;
  const holidays=state.showHolidays?getHolidaysForYear(state.view.y):{};
  const prevDays=new Date(state.view.y,state.view.m,0).getDate();
  for(let i=start-1;i>=0;i--){grid.appendChild(dayCell(new Date(state.view.y,state.view.m-1,prevDays-i),true,holidays));}
  for(let d=1;d<=days;d++){grid.appendChild(dayCell(new Date(state.view.y,state.view.m,d),false,holidays));}
  const rem=grid.children.length%7;
  if(rem){for(let i=1;i<=7-rem;i++){grid.appendChild(dayCell(new Date(state.view.y,state.view.m+1,i),true,holidays));}}
}
function dayCell(dateObj,other,holidays){
  const ymd=toLocalYMD(dateObj);
  const el=document.createElement("div");
  el.className="day"+(other?" other":"");
  el.innerHTML=`<div class="num">${dateObj.getDate()}</div><div class="tags"></div>`;
  const dayTasks=state.tasks.filter(t=>(t.due===ymd||t.linkedDay===ymd));
  if(dayTasks.length){
    const b=document.createElement("div");
    b.className="badge-count"; b.title="عدد المهام في هذا اليوم"; b.textContent=dayTasks.length;
    el.appendChild(b);
    const maxLines=3;
    const tagsBox=el.querySelector(".tags");
    dayTasks.slice(0,maxLines).forEach(t=>{
      const ttl=(t.title||"").trim();
      const line=document.createElement("div");
      line.className="tagline";
      line.textContent=`${ttl} — ${daysLeftLabel(t.due||ymd)}`;
      tagsBox.appendChild(line);
    });
    if(dayTasks.length>maxLines){
      const more=document.createElement("div");
      more.className="tagline"; more.textContent=`+${dayTasks.length-maxLines} أخرى…`;
      tagsBox.appendChild(more);
    }
  }
  const hasPinned=state.notes.some(n=>(n.pinned && n.linkedDate===ymd));
  if(hasPinned){const pin=document.createElement("div");pin.className="pin-mini";pin.textContent="📌";el.appendChild(pin);}
  if(ymd===todayYMD()) el.classList.add("today");
  if(state.showHolidays && holidays[ymd]){
    const tag=document.createElement("div");tag.className="holiday";tag.textContent=`🎉 ${holidays[ymd]} — ${daysLeftLabel(ymd)}`;
    el.querySelector(".tags").appendChild(tag);
  }
  el.addEventListener("click",()=>{
    grid.querySelectorAll(".day.selected").forEach(d=>d.classList.remove("selected"));
    el.classList.add("selected"); state.selectedDate=ymd; dueEl && (dueEl.value=ymd); renderTasks();
  });
  return el;
}

const ORDER=["todo","doing","think","done"];
const STATUS_INFO={todo:{label:"بانتظار التنفيذ",icon:"⏳",color:"#facc15"},doing:{label:"قيد التنفيذ",icon:"🔧",color:"#fb923c"},think:{label:"قيد التفكير",icon:"💭",color:"#a855f7"},done:{label:"جاهز",icon:"✅",color:"#22c55e"}};
function statusIconHTML(st){const s=STATUS_INFO[st]||STATUS_INFO.todo;return `<span class="sticon" style="--st:${s.color}">${s.icon}</span>`;}

/* تُظهر الكتجوريا السابقة للملاحظات عند الحاجة */
function contentTypeLabel(t){
  if(t.type === 'note'){
    if(t.prevCategory && String(t.prevCategory).trim()) return t.prevCategory;
    if(t.category && String(t.category).trim()) return t.category;
    return 'مهمة';
  }
  if(t.category && String(t.category).trim()) return t.category;
  return 'مهمة';
}

function renderTasks(){
  for(const k in lists) lists[k].innerHTML="";
  const q=(searchEl.value||"").trim().toLowerCase();
  const fSt=state.filters.status, fPr=state.filters.prio;
  const filtered=state.tasks.filter(t=>{
    const matchQ=!q||(t.title||"").toLowerCase().includes(q)||(t.notes||"").toLowerCase().includes(q);
    const matchD=state.selectedDate?(t.due===state.selectedDate||t.linkedDay===state.selectedDate):true;
    const matchS=!fSt||(t.status===fSt);
    const matchP=!fPr||(t.priority===fPr);
    return matchQ&&matchD&&matchS&&matchP;
  });
  const buck={todo:[],doing:[],think:[],done:[]};
  filtered.forEach(t=>buck[t.status||"todo"].push(t));
  for(const st in buck){
    counts[st].textContent=buck[st].length;
    buck[st].sort((a,b)=>(a.due||"9999").localeCompare(b.due||"9999")||(a.title||"").localeCompare(b.title||""))
      .forEach(t=>lists[st].appendChild(taskCard(t)));
  }
  attachDnD();
}

function progressPercent(t){
  const created=t.createdAt?parseYMD(t.createdAt):new Date();
  const due=t.due?parseYMD(t.due):new Date();
  const today=new Date();
  const totalMs=Math.max(1,due-created);
  const passed=clamp(today-created,0,totalMs);
  return Math.round((passed/totalMs)*100);
}

function taskCard(t){
  const p=progressPercent(t);
  const card=document.createElement("div");
  card.className="task";
  card.dataset.id=t.id;
  card.draggable=true;

  const title=document.createElement("div");
  title.className="title";
  // ❌ أزلنا النوع بجانب العنوان — إبقاءه فقط في الميتا
  title.innerHTML=`${statusIconHTML(t.status)} ${escapeHTML(t.title||"")}`;

  const progress=document.createElement("div");
  progress.className="progress-line";
  progress.style.width=`${clamp(p,0,100)}%`;

  // ✅ ترتيب الميتا: تاريخ المهمة | النوع | الأولوية | المتبقي (المتبقي يظهر آخر اليسار)
  const kind = contentTypeLabel(t);
  const prio = priorityLabel(t.priority||"med");
  const meta=document.createElement("div");
  meta.className="meta";
  meta.innerHTML = `
    <span class="due">تاريخ المهمة: ${t.due||"-"}</span>
    <span class="kind">| النوع: ${escapeHTML(kind)}</span>
    <span class="prio">| الأولوية: ${escapeHTML(prio)}</span>
    <span class="remain">${daysLeftLabel(t.due||todayYMD())}</span>
  `;

  // لمس/سحب — لا يفتح التفاصيل عند السحب
  let tsX=null,tsY=null;
  card.addEventListener("touchstart",e=>{const c=e.changedTouches[0];tsX=c.clientX;tsY=c.clientY;card.dataset.dragging="0";},{passive:true});
  card.addEventListener("touchmove",e=>{if(tsX==null)return;const c=e.changedTouches[0];const dx=Math.abs(c.clientX-tsX),dy=Math.abs(c.clientY-tsY);if(dx>6||dy>6) card.dataset.dragging="1";},{passive:true});
  card.addEventListener("touchend",e=>{
    if(tsX==null)return;
    const c=e.changedTouches[0]; const dx=c.clientX-tsX, dy=c.clientY-tsY;
    const absx=Math.abs(dx), absy=Math.abs(dy);
    if(absx>40 && absy<30){ if(dx<0) stepStatus(t.id,+1); else stepStatus(t.id,-1); }
    else if(card.dataset.dragging!=="1"){ openTaskDetail(t.id); }
    tsX=tsY=null; card.dataset.dragging="0";
  },{passive:true});
  card.addEventListener("click",(e)=>{
    if(card.dataset.dragging==="1"){ e.stopPropagation(); e.preventDefault(); card.dataset.dragging="0"; return; }
    openTaskDetail(t.id);
  });
  card.addEventListener("dragstart",ev=>{ev.dataTransfer.setData("text/plain",t.id);});

  card.append(progress,title,meta);
  return card;
}

function stepStatus(id,dir){
  const i=state.tasks.findIndex(x=>x.id===id);
  if(i<0)return;
  const cur=state.tasks[i].status||"todo";
  const ni=clamp(ORDER.indexOf(cur)+dir,0,ORDER.length-1);
  if(ni!==ORDER.indexOf(cur)){
    snapshot();
    const newSt=ORDER[ni];
    state.tasks[i].status=newSt;
    if(newSt==='done'){ state.tasks[i].doneAt=Date.now(); }
    else { state.tasks[i].doneAt=null; }
    saveAll(); renderTasks(); renderCalendar();
    // دفع إلى السحابة
    cloudUpsert("tasks", state.tasks[i]);
    showToast("info","تم تحديث الحالة",true);
  }
}

function attachDnD(){
  document.querySelectorAll(".droptarget").forEach(col=>{
    col.addEventListener("dragover",ev=>{ev.preventDefault();col.classList.add("drag");});
    col.addEventListener("dragleave",()=>col.classList.remove("drag"));
    col.addEventListener("drop",ev=>{
      ev.preventDefault();col.classList.remove("drag");
      const id=ev.dataTransfer.getData("text/plain");
      const st=col.dataset.status;
      const i=state.tasks.findIndex(t=>t.id===id);
      if(i<0)return;
      if(state.tasks[i].status!==st){
        snapshot();
        state.tasks[i].status=st;
        if(st==='done'){ state.tasks[i].doneAt=Date.now(); } else { state.tasks[i].doneAt=null; }
        saveAll(); renderTasks(); renderCalendar();
        // دفع إلى السحابة
        cloudUpsert("tasks", state.tasks[i]);
        showToast("info","↔️ نُقلت المهمة",true);
      }
    });
  });
}

function getTask(id){return state.tasks.find(x=>x.id===id);}

function openTaskDetail(id){
  const t=getTask(id); if(!t)return;
  state.currentTaskId=id;
  byId("taskModalTitle").textContent=t.title||"تفاصيل";
  byId("taskModalMeta").textContent=`الحالة: ${(STATUS_INFO[t.status]||STATUS_INFO.todo).label} | الأولوية: ${priorityLabel(t.priority||"med")} | الإنشاء: ${t.createdAt||"-"} | تاريخ المهمة: ${t.due||"-"}`;
  byId("taskModalNotes").textContent=(t.notes && t.notes.trim())?("ملاحظات: "+t.notes):"لا توجد ملاحظات.";
  byId("taskModal").hidden=false;

  // زر "تحويل إلى ملاحظة"
  (function ensureTaskToNoteButton(){
    const modal = byId('taskModal'); if(!modal) return;
    const actionsRow = modal.querySelector('.modal-actions') || modal;
    if (byId('taskToNote')) return;
    const delBtn = byId('taskDelete');
    const btn = document.createElement('button');
    btn.id = 'taskToNote'; btn.className = 'btn'; btn.type = 'button';
    btn.textContent = '📝 تحويل إلى ملاحظة';
    btn.addEventListener('click', () => { convertTaskToNote(state.currentTaskId); byId("taskModal").hidden = true; });
    if (delBtn && delBtn.parentElement === actionsRow) actionsRow.insertBefore(btn, delBtn);
    else actionsRow.appendChild(btn);
  })();
}

byId("taskClose").addEventListener("click",()=>byId("taskModal").hidden=true);
byId("taskEdit").addEventListener("click",()=>{const t=getTask(state.currentTaskId);if(t){loadToSheet(t);byId("taskModal").hidden=true;openSheet();}});
byId("taskArchive").addEventListener("click",()=>{if(!state.currentTaskId)return;archiveTask(state.currentTaskId);byId("taskModal").hidden=true;});
byId("taskDelete").addEventListener("click",()=>{if(!state.currentTaskId)return;deleteTask(state.currentTaskId);byId("taskModal").hidden=true;});

function renderNotes(){
  notesAuto.innerHTML="";
  const taskNotes=state.tasks.filter(t=>t.type==="note");
  const list=taskNotes.map(t=>{
    const extra=state.notes.find(n=>n.id===t.id)||{};
    return {id:t.id,text:t.title||t.notes||"",createdAt:t.createdAt||"",pinned:!!extra.pinned,linkedDate:t.due||t.linkedDay||null};
  }).filter(n=>{
    const q=(notesSearch.value||"").trim().toLowerCase();
    return !q || (n.text||"").toLowerCase().includes(q);
  }).sort((a,b)=>(b.pinned?1:0)-(a.pinned?1:0));

  if(list.length===0){
    const e=document.createElement("div"); e.className="note"; e.textContent="لا توجد ملاحظات."; notesAuto.appendChild(e); return;
  }

  list.forEach(n=>{
    const row=document.createElement("div");
    row.className="note"; if(n.pinned) row.classList.add("pinned");

    const source = state.tasks.find(t => t.id === n.id);
    const prevKind = source ? (source.prevCategory || source.category || 'مهمة') : 'مهمة';

    row.innerHTML=`
      <div class="note-title">${escapeHTML(n.text)} ${n.pinned?"📌":""}</div>
      <div class="note-meta">مرتبط بتاريخ: ${n.linkedDate||"-"}</div>
      <div class="note-footer">
        <span class="type-badge">${escapeHTML(prevKind)}</span>
      </div>
      <div class="swipe-actions">
        <button class="act archive">🗄️ أرشفة</button>
        <button class="act edit">✏️ تعديل</button>
        <button class="act toTask">✅ تحويل لمهمة</button>
        <button class="act del">🗑️ حذف</button>
      </div>`;

    row.addEventListener("click",()=>openNoteDetail(n.id));
    let sx=null,sy=null;
    row.addEventListener("touchstart",e=>{const c=e.changedTouches[0];sx=c.clientX;sy=c.clientY;},{passive:true});
    row.addEventListener("touchend",e=>{const c=e.changedTouches[0];if(sx==null)return;const dx=c.clientX-sx,dy=c.clientY-sy;if(Math.abs(dx)>30 && Math.abs(dy)<25){row.classList.toggle("show-actions",dx<0);}sx=sy=null;},{passive:true});

    // ✅ إصلاح عدم عمل الأزرار على الهاتف (دعم touchend)
    const bind = (sel, fn) => {
      const el = row.querySelector(sel);
      el.addEventListener("click",ev=>{ev.stopPropagation(); fn(); row.classList.remove("show-actions");});
      el.addEventListener("touchend",ev=>{ev.preventDefault(); ev.stopPropagation(); fn(); row.classList.remove("show-actions");}, {passive:false});
    };
    bind(".archive", ()=>archiveNote(n.id));
    bind(".edit", ()=>editNote(n.id));
    bind(".toTask", ()=>{state.currentNoteId=n.id; convertNoteToTask();});
    bind(".del", ()=>deleteNote(n.id));

    notesAuto.appendChild(row);
  });
}
notesSearch.addEventListener("input",debounce(()=>renderNotes(),120));

function openNoteDetail(id){
  const t=state.tasks.find(x=>x.id===id && x.type==="note"); if(!t)return;
  state.currentNoteId=id;
  const pinned=!!(state.notes.find(n=>n.id===id)?.pinned);
  byId("noteModalTitle").textContent=(t.title||"(ملاحظة)")+(pinned?" 📌":"");
  byId("noteModalMeta").textContent=`الإنشاء: ${t.createdAt||"-"} | مرتبط بتاريخ: ${t.due||"-"}`;
  byId("noteModalText").textContent=(t.notes && t.notes.trim())?t.notes:"لا يوجد محتوى إضافي.";
  byId("noteModal").hidden=false;
}
byId("noteClose").addEventListener("click",()=>byId("noteModal").hidden=true);
byId("noteToTask").addEventListener("click",()=>convertNoteToTask());
byId("noteArchive").addEventListener("click",()=>{if(!state.currentNoteId)return;archiveNote(state.currentNoteId);byId("noteModal").hidden=true;});
byId("noteDelete").addEventListener("click",()=>{if(!state.currentNoteId)return;deleteNote(state.currentNoteId);byId("noteModal").hidden=true;});

function editNote(id){const t=state.tasks.find(x=>x.id===id && x.type==="note");if(!t)return;loadToSheet(t);openSheet();}
function convertNoteToTask(){
  const id=state.currentNoteId; if(!id)return;
  const i=state.tasks.findIndex(x=>x.id===id && x.type==="note"); if(i<0)return;
  snapshot();
  state.tasks[i].type="task";
  state.tasks[i].status = state.tasks[i].prevStatus || state.tasks[i].status || "todo";
  state.notes=state.notes.filter(n=>n.id!==id);
  saveAll(); renderTasks(); renderNotes(); renderCalendar();
  // سحابة
  cloudUpsert("tasks", state.tasks[i]);
  cloudRemove("notes", id);
  showToast("success","حوّلنا الملاحظة إلى مهمة",true);
}

function convertTaskToNote(id){
  const i = state.tasks.findIndex(t => t.id === id);
  if (i < 0) return;
  const t = state.tasks[i];
  if (t.type === 'note') { showToast && showToast('info', 'هذه بالفعل ملاحظة'); return; }
  snapshot();
  if (!t.prevCategory) t.prevCategory = (t.category && String(t.category).trim()) ? t.category : 'مهمة';
  t.type = 'note'; t.status = 'think'; t.convertedAt = todayYMD();
  if (!state.notes.some(n => n.id === t.id)) {
    const meta = { id: t.id, text: t.title || t.notes || "", pinned: false, linkedTask: t.id, linkedDate: t.due || t.linkedDay || null };
    state.notes.unshift(meta);
    // سحابة
    cloudUpsert("notes", meta);
  }
  saveAll(); renderTasks(); renderNotes(); renderCalendar();
  // سحابة
  cloudUpsert("tasks", t);
  showToast && showToast('success', '📝 تم تحويل المهمة إلى ملاحظة', true);
}

function openSheet(){sheet.classList.add("open");if(window.innerWidth>640)setTimeout(()=>titleEl.focus(),60);const td=todayYMD();if(!createdEl.value)createdEl.value=td;dueEl.value=state.selectedDate||dueEl.value||td;}
function closeSheet(){sheet.classList.remove("open");}
function resetSheet(){editIdEl.value="";titleEl.value="";statusEl.value="todo";typeEl.value="task";prioEl.value="med";const td=todayYMD();createdEl.value=td;dueEl.value=state.selectedDate||td;notesEl.value="";smartHint.style.display="none";}
byId("sheetClose").addEventListener("click",closeSheet);
byId("sheetReset").addEventListener("click",resetSheet);
byId("fab").addEventListener("click",openSheet);

titleEl.addEventListener("input",e=>applySmartParsing(e.target.value));
function normalizeArabic(s){return s.replace(/[اأإآ]/g,"ا").replace(/ة/g,"ه").replace(/ى/g,"ي").replace(/\s+/g," ").trim().toLowerCase();}
const wordsMap={"واحد":1,"احد":1,"اثنين":2,"ثنين":2,"ثلاثه":3,"ثلاث":3,"اربعه":4,"خمسه":5,"سته":6,"ست":6,"سبعه":7,"ثمانيه":8,"ثمنيه":8,"تسعه":9,"عشره":10,"حداش":11,"احدى عشر":11,"طناش":12,"اثنا عشر":12,"ثلطاش":13,"اربعطاشر":14,"خمسطاش":15,"سطاش":16,"سبعطاش":17,"ثمنطاش":18,"تسعطاش":19,"عشرين":20,"واحد وعشرين":21,"احد وعشرين":21,"اثنين وعشرين":22,"ثنين وعشرين":22,"ثلاثه وعشرين":23,"ثلاث وعشرين":23,"اربعه وعشرين":24,"خمسه وعشرين":25,"سته وعشرين":26,"سبعه وعشرين":27,"ثمانيه وعشرين":28,"ثمنيه وعشرين":28,"تسعه وعشرين":29};
function wordNum(w){const n=wordsMap[w];return (typeof n==="number")?n:null;}
function tokenToNum(tok){return wordNum(tok) ?? (/^\d+$/.test(tok)?parseInt(tok,10):null);}
function parseDayMonthFromPhrase(text){const t=normalizeArabic(text);const sp=t.match(/(واحد|احد|اثنين|ثنين|ثلاثه|ثلاث|اربعه|خمسه|سته|ست|سبعه|ثمانيه|ثمنيه|تسعه)\s*و\s*عشرين\s+(عشره|10)/);if(sp){const d=wordNum(sp[1])||0;return {day:20+d,month:10};}const parts=t.split(" ");for(let i=0;i<parts.length-1;i++){const d=tokenToNum(parts[i]);const m=tokenToNum(parts[i+1]);if(Number.isInteger(d)&&d>=1&&d<=31 && Number.isInteger(m)&&m>=1&&m<=12) return {day:d,month:m};}return null;}
function applySmartParsing(title){smartHint.style.display="none";const dm=parseDayMonthFromPhrase(title);if(dm){const y=(new Date()).getFullYear();const d=new Date(y,dm.month-1,dm.day);const ymd=toLocalYMD(d);dueEl.value=ymd;smartHint.textContent="تم تحديد التاريخ تلقائيًا: "+ymd;smartHint.style.display="inline";setTimeout(()=>smartHint.style.display="none",2000);}}

byId("sheetSave").addEventListener("click",submitSheet);
function submitSheet(){
  const id=editIdEl.value||uid();
  const exists=state.tasks.some(t=>t.id===id);
  const title=(titleEl.value||"").trim();
  if(!title){showToast("error","⚠️ العنوان مطلوب");return;}
  snapshot();
  const chosenType=typeEl.value;
  const statusVal=chosenType==="note"?"think":statusEl.value;
  const payload={id,title,status:statusVal,type:chosenType,priority:prioEl.value,createdAt:createdEl.value||todayYMD(),due:dueEl.value||state.selectedDate||todayYMD(),linkedDay:dueEl.value||state.selectedDate||todayYMD(),notes:(notesEl.value||"").trim()};
  if(exists){const i=state.tasks.findIndex(t=>t.id===id);state.tasks[i]={...state.tasks[i],...payload};}
  else{state.tasks.unshift(payload);}
  if(payload.type==="note"){
    const ni=state.notes.findIndex(n=>n.id===id);
    const rec={id,text:payload.title||payload.notes||"",pinned:(ni>=0?!!state.notes[ni].pinned:false),linkedTask:id,linkedDate:payload.due};
    if(ni>=0) state.notes[ni]={...state.notes[ni],...rec}; else state.notes.unshift(rec);
    // سحابة
    cloudUpsert("notes", rec);
  }else{
    state.notes=state.notes.filter(n=>n.id!==id);
    // سحابة
    cloudRemove("notes", id);
  }
  saveAll(); renderTasks(); renderNotes(); renderCalendar();
  // سحابة
  cloudUpsert("tasks", payload);

  closeSheet(); resetSheet();
  showToast("success",exists?"تم تحديث العنصر":"تمت الإضافة",true);
}

searchEl.addEventListener("input",debounce(()=>renderTasks(),200));
showAllBtn.addEventListener("click",()=>{state.selectedDate=null;document.querySelectorAll(".day.selected").forEach(d=>d.classList.remove("selected"));renderTasks();showToast("info","عرض جميع المهام");});
filterStatus.addEventListener("change",()=>{state.filters.status=filterStatus.value;renderTasks();});
filterPrio.addEventListener("change",()=>{state.filters.prio=filterPrio.value;renderTasks();});

byId("prevMonth").addEventListener("click",()=>{if(state.view.m===0){state.view.m=11;state.view.y--;}else state.view.m--;renderCalendar();});
byId("nextMonth").addEventListener("click",()=>{if(state.view.m===11){state.view.m=0;state.view.y++;}else state.view.m++;renderCalendar();});
byId("todayBtn").addEventListener("click",()=>{const d=new Date();state.view.m=d.getMonth();state.view.y=d.getFullYear();state.selectedDate=todayYMD();renderCalendar();renderTasks();});

function archiveTask(id){
  const i=state.tasks.findIndex(t=>t.id===id);if(i<0)return;
  snapshot();
  const t=state.tasks.splice(i,1)[0];
  state.archived.unshift({type:"task",item:{...t,finishedAt:todayYMD()}});
  state.notes=state.notes.filter(n=>n.id!==id);
  saveAll();renderTasks();renderCalendar();renderNotes();
  // سحابة
  cloudUpsert("archived", { id:(t.id+"_"+Date.now()), type:"task", item:{...t,finishedAt:todayYMD()} });
  cloudRemove("tasks", id);
  cloudRemove("notes", id);
  showToast("warn","🗄️ تمت الأرشفة",true);
}
function deleteTask(id){
  snapshot();
  state.tasks=state.tasks.filter(t=>t.id!==id);
  state.notes=state.notes.filter(n=>n.id!==id);
  saveAll();renderTasks();renderCalendar();renderNotes();
  // سحابة
  cloudRemove("tasks", id);
  cloudRemove("notes", id);
  showToast("error","🗑️ تم الحذف",true);
}

function renderArchiveTabs(){
  const archTasksBox=byId("archTasks"),archNotesBox=byId("archNotes");
  archTasksBox.innerHTML="";archNotesBox.innerHTML="";
  const tasks=state.archived.filter(r=>r.type==="task");
  const notes=state.archived.filter(r=>r.type==="note");
  if(tasks.length===0){archTasksBox.innerHTML=`<div class="arch-item" style="opacity:.7">لا توجد مهام مؤرشفة.</div>`;}
  else tasks.forEach(r=>{
    const t=r.item;
    const row=document.createElement("div");
    row.className="arch-item";
    row.innerHTML=`<div><strong>${escapeHTML(t.title||"(بدون عنوان)")}</strong><div class="meta">تاريخ المهمة: ${t.due||"-"} | الإنشاء: ${t.createdAt||"-"}</div></div><div class="arch-actions"><button class="btn" data-act="restore">استرجاع</button><button class="btn danger" data-act="delete">حذف</button></div>`;
    row.querySelector('[data-act="restore"]').addEventListener("click",()=>{snapshot();state.tasks.unshift(t);state.archived=state.archived.filter(x=>x!==r);saveAll();renderTasks();renderArchiveTabs();renderCalendar();
      // سحابة
      cloudUpsert("tasks", t);
      cloudRemove("archived", r.id || (t.id+""));
      showToast("success","♻️ تمت الاستعادة",true);
    });
    row.querySelector('[data-act="delete"]').addEventListener("click",()=>{snapshot();state.archived=state.archived.filter(x=>x!==r);saveAll();renderArchiveTabs();
      // سحابة
      cloudRemove("archived", r.id || (t.id+""));
      showToast("error","🗑️ تم الحذف نهائيًا",true);
    });
    archTasksBox.appendChild(row);
  });
  if(notes.length===0){archNotesBox.innerHTML=`<div class="arch-item" style="opacity:.7">لا توجد ملاحظات مؤرشفة.</div>`;}
  else notes.forEach(r=>{
    const t=r.item;
    const row=document.createElement("div");
    row.className="arch-item";
    row.innerHTML=`<div><strong>${escapeHTML(t.title||"(ملاحظة)")}</strong><div class="meta">الإنشاء: ${t.createdAt||"-"} | مرتبط بتاريخ: ${t.due||"-"}</div></div><div class="arch-actions"><button class="btn" data-act="restore">استرجاع</button><button class="btn danger" data-act="delete">حذف</button></div>`;
    row.querySelector('[data-act="restore"]').addEventListener("click",()=>{snapshot();state.tasks.unshift(t);state.archived=state.archived.filter(x=>x!==r);saveAll();renderNotes();renderArchiveTabs();renderCalendar();
      // سحابة
      cloudUpsert("tasks", t);
      cloudRemove("archived", r.id || (t.id+""));
      showToast("success","♻️ تمت الاستعادة",true);
    });
    row.querySelector('[data-act="delete"]').addEventListener("click",()=>{snapshot();state.archived=state.archived.filter(x=>x!==r);saveAll();renderArchiveTabs();
      // سحابة
      cloudRemove("archived", r.id || (t.id+""));
      showToast("error","🗑️ تم الحذف نهائيًا",true);
    });
    archNotesBox.appendChild(row);
  });
}

const openArchiveBtn=byId("openArchive"),closeArchiveBtn=byId("closeArchive");const archiveModal=byId("archiveModal");
openArchiveBtn.addEventListener("click",()=>{renderArchiveTabs();archiveModal.hidden=false;});
closeArchiveBtn.addEventListener("click",()=>archiveModal.hidden=true);
document.querySelectorAll(".tabs .tab").forEach(btn=>{
  btn.addEventListener("click",()=>{
    document.querySelectorAll(".tabs .tab").forEach(b=>b.classList.remove("active"));
    btn.classList.add("active");
    const id=btn.dataset.tab;
    byId("archTasks").hidden=id!=="archTasks";
    byId("archNotes").hidden=id!=="archNotes";
  });
});

function loadToSheet(t){editIdEl.value=t.id;titleEl.value=t.title||"";statusEl.value=t.status||"todo";typeEl.value=t.type==="note"?"note":"task";prioEl.value=t.priority||"med";createdEl.value=t.createdAt||todayYMD();dueEl.value=t.due||todayYMD();notesEl.value=t.notes||"";}
function enableModalAutoClose(modal){modal.addEventListener("click",(e)=>{const card=modal.querySelector(".modal-card");if(!card)return;if(!card.contains(e.target)) modal.hidden=true;});}
["taskModal","noteModal","archiveModal"].forEach(id=>enableModalAutoClose(byId(id)));
document.addEventListener("keydown",(e)=>{if(e.key==="Escape"){["taskModal","noteModal","archiveModal"].forEach(id=>{const m=byId(id);if(m && !m.hidden) m.hidden=true;});if(sheet.classList.contains("open")) closeSheet();}});

document.addEventListener("DOMContentLoaded",async()=>{
  applyDarkMode();settingsPop.hidden=true;sheet.classList.remove("open");
  const td=todayYMD();if(!createdEl.value) createdEl.value=td;if(!dueEl.value) dueEl.value=td;
  try{await ensureHolidaysLoaded();}catch{}
  renderCalendar();renderTasks();renderNotes();
  window.addEventListener('error',()=>{const sp=byId('splash');if(sp) sp.remove();});
  setTimeout(()=>{const sp=byId('splash');if(sp){sp.style.opacity='0';sp.style.transition='opacity .4s';setTimeout(()=>sp.remove(),420);}},900);

  // تشغيل مزامنة Firebase إن وُجدت
  try{ bootFirebaseSync(); }catch{}
});

/* ==== Unified Flow Patch — Auto-convert done→note after 7 days + badge positioning ==== */
(function(){
  const WEEK_MS = 7 * 24 * 60 * 60 * 1000;

  function autoConvertDoneTasksToNotes(){
    const now = Date.now();
    let converted=0;
    for(const t of state.tasks){
      if(!t) continue;
      if(t.type!=='note' && t.status==='done' && t.doneAt && (now - t.doneAt) >= WEEK_MS){
        if (!t.prevCategory) t.prevCategory = (t.category && String(t.category).trim()) ? t.category : 'مهمة';
        t.type = 'note'; t.status = 'think'; t.convertedAt = todayYMD();
        if(!state.notes.some(n=>n.id===t.id)){
          state.notes.unshift({ id: t.id, text: t.title || t.notes || "", pinned: false, linkedTask: t.id, linkedDate: t.due || t.linkedDay || null });
          // سحابة
          cloudUpsert("notes", { id: t.id, text: t.title || t.notes || "", pinned: false, linkedTask: t.id, linkedDate: t.due || t.linkedDay || null });
        }
        // سحابة
        cloudUpsert("tasks", t);
        converted++;
      }
    }
    if(converted){
      saveAll(); renderTasks(); renderNotes(); renderCalendar();
      try{ showToast('info', `تم تحويل ${converted} مهمّة إلى ملاحظات تلقائيًا.`); }catch{}
    }
  }

  function daysUntilConversion(t){
    if(!t || t.type==='note' || t.status!=='done' || !t.doneAt) return null;
    const ms = (t.doneAt + WEEK_MS) - Date.now();
    return Math.max(0, Math.ceil(ms/86400000));
  }
  function updateDoneBadges(){
    const doneList = byId('list-done'); if(!doneList) return;
    const cards = doneList.querySelectorAll('.task');
    const map = Object.fromEntries(state.tasks.map(x=>[String(x.id),x]));
    cards.forEach(card=>{
      const id = card.dataset.id; const t = map[id];
      const days = daysUntilConversion(t);
      let badge = card.querySelector('.convert-badge');
      if(days==null){ if(badge) badge.remove(); }
      else{
        if(!badge){
          const title = card.querySelector('.title') || card;
          badge = document.createElement('span');
          badge.className='convert-badge';
          title.appendChild(badge);
        }
        badge.textContent = `يتحوّل بعد ${days} يوم`;
      }
    });
  }
  function observeDoneList(){
    const doneList = byId('list-done'); if(!doneList || typeof MutationObserver==='undefined') return;
    const obs = new MutationObserver(()=> setTimeout(updateDoneBadges, 0));
    obs.observe(doneList,{childList:true,subtree:true});
    setTimeout(updateDoneBadges,0);
  }

  document.addEventListener('DOMContentLoaded', ()=>{
    try{ autoConvertDoneTasksToNotes(); }catch{}
    try{ observeDoneList(); }catch{}
    setInterval(()=>{ try{ updateDoneBadges(); }catch{} }, 60*1000);
    setInterval(()=>{ try{ autoConvertDoneTasksToNotes(); }catch{} }, 60*60*1000);
  });
})();

/* ===== [ADDON] Haptic + Close Toast on tap/click + Ripple + Pull-To-Refresh ===== */

/* Haptic (اهتزاز خفيف) */
function vibrate(ms=18, targetEl){
  try{
    if (navigator.vibrate && typeof navigator.vibrate === 'function') {
      navigator.vibrate(ms);
      return true;
    }
  }catch{}
  // فfallback بصري للأجهزة غير المدعومة (مثل iOS Safari)
  if (targetEl && targetEl.classList) {
    targetEl.classList.remove('haptic-bump'); // لإعادة التشغيل بسرعة
    // إجبار إعادة تدفق لإعادة الأنيميشن
    // eslint-disable-next-line no-unused-expressions
    targetEl.offsetWidth;
    targetEl.classList.add('haptic-bump');
  }
  return false;
}

/* إغلاق جميع التوست عند اللمس/النقر (لا يغيّر showToast لديك) */
(function(){
  function closeAllToasts(){ document.querySelectorAll('.toast').forEach(t=>t.remove()); }
  document.addEventListener('touchstart', closeAllToasts, {passive:true});
  document.addEventListener('click', closeAllToasts, true);
})();

/* Ripple Effect (بدون تغيير ألوانك) */
(function(){
  const SEL = '.btn, .task, .note';
  document.addEventListener('pointerdown', (e)=>{
    const el = e.target.closest(SEL);
    if(!el) return;
    const rect = el.getBoundingClientRect();
    const size = Math.max(rect.width, rect.height);
    const x = (e.clientX ?? 0) - rect.left;
    const y = (e.clientY ?? 0) - rect.top;
    const span = document.createElement('span');
    span.className = 'ripple';
    span.style.width = span.style.height = size+'px';
    span.style.left = (x - size/2)+'px';
    span.style.top  = (y - size/2)+'px';
    el.classList.add('ripple-parent');
    el.appendChild(span);
    span.addEventListener('animationend', ()=> span.remove());
  }, {passive:true});
})();

/* اهتزاز تلقائي عند الأفعال الشائعة (بدون تعديل دوالك) */
(function(){
  const clickMap = [
    '#sheetSave', '#sheetReset', '#taskArchive', '#taskDelete', '#taskToNote',
    '#noteToTask', '#noteArchive', '#noteDelete', '#openArchive', '#closeArchive',
    '#prevMonth', '#nextMonth', '#todayBtn', '#showAll'
  ];
document.addEventListener('click',(e)=>{
  const tgt = e.target;
  if(tgt.closest(clickMap.join(','))) vibrate(18, tgt.closest('button, .btn, .act, .task, .note') || tgt);
  if(tgt.classList && (tgt.classList.contains('act') || tgt.closest('.act'))) vibrate(18, tgt.closest('.act') || tgt);
}, true);
})();

/* Pull-to-Refresh على الجوال فقط — يحدث التقويم + المهام + الملاحظات */
(function(){
  const isTouch = matchMedia('(pointer:coarse)').matches;
  if(!isTouch) return;

  let startY = 0, pulling = false, pulled = 0, bar = null, locked = false;
  function ensureBar(){
    if(bar) return bar;
    bar = document.createElement('div');
    bar.id = 'pullRefreshBar';
    bar.textContent = '↻ اسحب للتحديث';
    document.body.appendChild(bar);
    return bar;
  }
  function atTop(){ return (document.scrollingElement?.scrollTop || document.documentElement.scrollTop || window.scrollY || 0) <= 0; }

  window.addEventListener('touchstart', (e)=>{
    if(!atTop() || locked) return;
    startY = e.touches[0].clientY; pulling = true; pulled = 0;
  }, {passive:true});

  window.addEventListener('touchmove', (e)=>{
    if(!pulling || locked) return;
    const y = e.touches[0].clientY;
    pulled = Math.max(0, y - startY);
    if(pulled <= 0){ pulling = false; return; }
    // منع سحب المحتوى إذا بدأنا السحب نزولًا من أعلى الصفحة
    e.preventDefault();
    const b = ensureBar();
    const eased = Math.min(80, pulled*0.5); // سحب بصري لطيف
    b.classList.add('show');
    b.style.transform = `translate(-50%, ${eased-120}px)`;
    b.textContent = (pulled > 120) ? 'أفلِت للتحديث' : '↻ اسحب للتحديث';
  }, {passive:false});

  async function doRefresh(){
    const b = ensureBar();
    locked = true;
    b.classList.add('loading'); b.textContent='جارٍ التحديث…';
    try{
      // استدعِ دوالك الحالية بدون تغييرها:
      if(typeof renderCalendar==='function') renderCalendar();
      if(typeof renderTasks==='function')    renderTasks();
      if(typeof renderNotes==='function')    renderNotes();
      // لو عندك مزامنة سحابية، اتركها كما هي
      vibrate(16);
    }finally{
      setTimeout(()=>{
        b.classList.remove('loading','show');
        b.style.transform = ''; // يرجع فوق
        locked = false;
      }, 450);
      try{ if(typeof showToast==='function') showToast('info','تم التحديث'); }catch{}
    }
  }

  window.addEventListener('touchend', ()=>{
    if(!pulling || locked) return;
    const b = ensureBar();
    if(pulled > 120){ doRefresh(); }
    else{
      b.classList.remove('show');
      b.style.transform = '';
    }
    pulling = false; pulled = 0;
  });
})();

/* ===== iDEO Addons: Animations + Compact Toggle + Success Sound ===== */

/* ——— Success sound (WebAudio لا يحتاج ملف) ——— */
const iDEO_audioCtx = (window.AudioContext || window.webkitAudioContext) ? new (window.AudioContext || window.webkitAudioContext)() : null;
function playSuccess(freq=880, durMs=120, vol=0.08){
  try{
    if(!iDEO_audioCtx) return;
    const o = iDEO_audioCtx.createOscillator();
    const g = iDEO_audioCtx.createGain();
    o.type='sine';
    o.frequency.value=freq;
    g.gain.value=vol;
    o.connect(g); g.connect(iDEO_audioCtx.destination);
    o.start();
    setTimeout(()=>{ o.stop(); }, durMs);
  }catch{}
}

/* ——— Haptic (مع fallback بصري) ——— */
function vibrate(ms=18, targetEl){
  try{
    if (navigator.vibrate && typeof navigator.vibrate === 'function') {
      navigator.vibrate(ms);
      return true;
    }
  }catch{}
  if (targetEl && targetEl.classList) {
    targetEl.classList.remove('haptic-bump');
    // force reflow
    // eslint-disable-next-line no-unused-expressions
    targetEl.offsetWidth;
    targetEl.classList.add('haptic-bump');
  }
  return false;
}

/* ——— Animations helpers ——— */
function animateTask(id, cls){
  const el = document.querySelector(`.task[data-id="${id}"]`);
  if(!el) return;
  el.classList.add(cls);
  setTimeout(()=> el.classList.remove(cls), 450);
}

/* نضيف مراقب يوسّم البطاقات الجديدة بـ .added تلقائيًا */
(function observeTaskLists(){
  const listsIds = ['list-todo','list-doing','list-think','list-done'];
  const obsCfg = {childList:true, subtree:false};
  listsIds.forEach(lid=>{
    const el = document.getElementById(lid);
    if(!el || typeof MutationObserver==='undefined') return;
    const obs = new MutationObserver(muts=>{
      muts.forEach(m=>{
        m.addedNodes && m.addedNodes.forEach(n=>{
          if(n.nodeType===1 && n.classList.contains('task')){
            n.classList.add('added');
            setTimeout(()=> n.classList.remove('added'), 500);
          }
        });
      });
      // بعد أي تغيير، حدّث compact meta
      try{ refreshCompactMeta(); }catch{}
    });
    obs.observe(el, obsCfg);
  });
})();

/* عند إسقاط بطاقة في عمود — وميض بسيط */
document.addEventListener('drop',(e)=>{
  const col = e.target && e.target.closest && e.target.closest('.status-col');
  if(!col) return;
  col.classList.add('drop-welcome');
  setTimeout(()=>col.classList.remove('drop-welcome'), 450);
  playSuccess(700,90);
  vibrate(14, col);
}, true);

/* زرار شائعة: نضيف صوت + Haptic */
(function bindActionFeedback(){
  const clickMap = [
    '#sheetSave','#sheetReset','#taskArchive','#taskDelete','#taskToNote',
    '#noteToTask','#noteArchive','#noteDelete','#openArchive','#closeArchive',
    '#prevMonth','#nextMonth','#todayBtn','#showAll'
  ];
  document.addEventListener('click',(e)=>{
    const tgt = e.target;
    const hit = tgt.closest(clickMap.join(','));
    if(hit){
      playSuccess(880,100);
      vibrate(18, hit);
    }
    if(tgt.classList && (tgt.classList.contains('act') || tgt.closest('.act'))){
      const h = tgt.closest('.act') || tgt;
      playSuccess(820,95);
      vibrate(16, h);
    }
  }, true);
})();

/* ——— Compact View (عرض سريع) ——— */
/* نحفظ الحالة بشكل مستقل بدون لمس saveAll الخاص بك */
const COMPACT_KEY = 'ideo_compact_view';
function getCompact(){ try{return localStorage.getItem(COMPACT_KEY)==='1';}catch{return false} }
function setCompact(v){ try{ localStorage.setItem(COMPACT_KEY, v?'1':'0'); }catch{} }

/* نضيف خيار في نافذة الإعدادات (إن لم يكن موجودًا) */
(function ensureCompactToggleInSettings(){
  const pop = document.getElementById('settingsPop');
  if(!pop) return;
  if(pop.querySelector('#compactToggle')) return;
  const row = document.createElement('label');
  row.className='sw';
  row.style.cursor='pointer';
  row.innerHTML = `
    <input id="compactToggle" type="checkbox" />
    <span>🔎 عرض سريع (بطاقات صغيرة)</span>
  `;
  pop.appendChild(row);
  const chk = row.querySelector('#compactToggle');
  chk.checked = getCompact();
  document.body.classList.toggle('compact', chk.checked);
  chk.addEventListener('change', ()=>{
    setCompact(chk.checked);
    document.body.classList.toggle('compact', chk.checked);
    refreshCompactMeta();
    try{ showToast('info', chk.checked?'تم تفعيل العرض السريع':'تم إلغاء العرض السريع'); }catch{}
  });
})();

/* نصنع ميتا مختصرة تظهر فقط في وضع compact دون لمس taskCard الأصلي */
function buildCompactMetaForTask(t){
  const wrap = document.createElement('div');
  wrap.className='compact-meta';
  const due = document.createElement('span'); due.className='chip'; due.textContent = `📅 ${t.due||'-'}`;
  const created = document.createElement('span'); created.className='chip'; created.textContent = `🕒 الإنشاء: ${t.createdAt||'-'}`;
  const pr = document.createElement('span'); pr.className='chip'; 
  const prMap = {low:'منخفضة',med:'متوسطة',high:'مرتفعة'};
  pr.textContent = `⭐ ${prMap[t.priority||'med']||t.priority||'متوسطة'}`;
  wrap.append(due, created, pr);
  if(t.notes && t.notes.trim()){
    const det = document.createElement('span'); det.className='chip'; det.textContent='📝 تفاصيل موجودة';
    wrap.appendChild(det);
  }
  return wrap;
}

/* تحدّث/تولّد الميتا المختصرة لكل البطاقات */
function refreshCompactMeta(){
  const isOn = document.body.classList.contains('compact');
  const cards = document.querySelectorAll('.task');
  cards.forEach(card=>{
    // نظف أي ميتا مختصرة قديمة
    card.querySelectorAll('.compact-meta').forEach(x=>x.remove());
    if(!isOn) return;
    const id = card.dataset.id;
    if(!id) return;
    const t = (typeof state!=='undefined' && state.tasks) ? state.tasks.find(x=>x.id===id) : null;
    if(!t) return;
    const cm = buildCompactMetaForTask(t);
    card.appendChild(cm);
  });
}

/* شغّل الميتا المختصرة عند التحميل وبعد كل ريندر كبير */
document.addEventListener('DOMContentLoaded', ()=> {
  if(getCompact()) document.body.classList.add('compact');
  setTimeout(()=> refreshCompactMeta(), 30);
});

/* إن أمكن، وصلها بعد ريندراتك الكبيرة بدون لمس دوالك */
(function tryHookRenders(){
  const fnList = ['renderTasks','renderNotes','renderCalendar'];
  fnList.forEach(name=>{
    const fn = window[name];
    if(typeof fn === 'function'){
      window[name] = function(){
        const r = fn.apply(this, arguments);
        try{ refreshCompactMeta(); }catch{}
        return r;
      };
    }
  });
})();
